import { Prisma } from '@prisma/client';
import LazyVal    from '../shared/helpers/LazyVal';
import GitlabUser from '../shared/types/Gitlab/GitlabUser';


const userBase = Prisma.validator<Prisma.UserDefaultArgs>()({
                                                                include: { exercises: true }
                                                            });
const assignmentBase = Prisma.validator<Prisma.AssignmentDefaultArgs>()({
                                                                            include: {
                                                                                exercises: true,
                                                                                staff    : true
                                                                            }
                                                                        });
const exerciseBase = Prisma.validator<Prisma.ExerciseDefaultArgs>()({
                                                                        include: {
                                                                            assignment: true,
                                                                            members   : true,
                                                                            results   : true
                                                                        }
                                                                    });
const resultBase = Prisma.validator<Prisma.ResultDefaultArgs>()({
                                                                    include: {
                                                                        exercise: true
                                                                    }
                                                                });


export type User = Prisma.UserGetPayload<typeof userBase> & {
    isTeachingStaff: boolean
    isAdmin: boolean
    gitlabProfile: LazyVal<GitlabUser>
}
export type Assignment = Prisma.AssignmentGetPayload<typeof assignmentBase>
export type Exercise = Prisma.ExerciseGetPayload<typeof exerciseBase>
export type Result = Prisma.ResultGetPayload<typeof resultBase>