// Read from the .env file
// ATTENTION : This line MUST be the first of this file
require('dotenv').config();

import WorkerRole     from './process/WorkerRole';
import ClusterManager from './process/ClusterManager';
import API            from './express/API';


(new ClusterManager([ {
    role         : WorkerRole.API,
    quantity     : ClusterManager.CORES,
    restartOnFail: true,
    loadTask     : () => {
        return new API();
    }
} ])).run();
