import User from '../models/User';
import db   from '../helpers/DatabaseHelper';


class UserManager {
    private static _instance: UserManager;

    private constructor() { }

    public static get instance(): UserManager {
        if ( !UserManager._instance ) {
            UserManager._instance = new UserManager();
        }

        return UserManager._instance;
    }

    createObjectFromRawSql(raw: any): User {
        return User.createFromSql(raw);
    }

    async getByMail(mail: string): Promise<User | undefined> {
        const raw = await db<User>(User.tableName).where('userMail', mail).first();

        return raw ? this.createObjectFromRawSql(raw) : undefined;
    }

    async getById(id: number): Promise<User | undefined> {
        const raw = await db<User>(User.tableName).where('userID', id).first();

        return raw ? this.createObjectFromRawSql(raw) : undefined;
    }

    async getByIds(ids: Array<number>): Promise<Array<User>> {
        return Promise.all(ids.map(userId => this.getById(userId)));
    }

    async getByGitlabId(gitlabId: number): Promise<User | undefined> {
        const raw = await db<User>(User.tableName).where('userGitlabId', gitlabId).first();

        return raw ? this.createObjectFromRawSql(raw) : undefined;
    }

    async getByGitlabIds(gitlabIds: Array<number>): Promise<Array<User>> {
        return Promise.all(gitlabIds.map(gitlabId => this.getByGitlabId(gitlabId)));
    }
}


export default UserManager.instance;
