import { Express }     from 'express-serve-static-core';
import ApiRequest      from '../models/ApiRequest';
import express         from 'express';
import { StatusCodes } from 'http-status-codes';


class ParamsCallbackManager {
    private static _instance: ParamsCallbackManager;

    private constructor() { }

    public static get instance(): ParamsCallbackManager {
        if ( !ParamsCallbackManager._instance ) {
            ParamsCallbackManager._instance = new ParamsCallbackManager();
        }

        return ParamsCallbackManager._instance;
    }

    protected listenParam(paramName: string, backend: Express, context: any, functionName: string, indexName: string) {
        backend.param(paramName, (req: ApiRequest, res: express.Response, next: express.NextFunction, id: number | string) => {
            (context[functionName] as (id: number | Array<number>) => Promise<any>)(typeof id === 'string' ? JSON.parse(id) as Array<number> : id).then(result => {
                if ( result ) {
                    this.initBoundParams(req);
                    (req.boundParams as any)[indexName] = result;

                    next();
                } else {
                    req.session.sendResponse(res, StatusCodes.NOT_FOUND, {}, 'Param bounding failed: ' + paramName);
                }
            });
        });
    }

    initBoundParams(req: ApiRequest) {
        if ( !req.boundParams ) {
            req.boundParams = {};
        }
    }

    register(backend: Express) {
    }
}


export default ParamsCallbackManager.instance;
