import express    from 'express';
import ApiRequest from '../models/ApiRequest';
import Session    from '../controllers/Session';


class SessionMiddleware {
    private static _instance: SessionMiddleware;

    private constructor() { }

    public static get instance(): SessionMiddleware {
        if ( !SessionMiddleware._instance ) {
            SessionMiddleware._instance = new SessionMiddleware();
        }

        return SessionMiddleware._instance;
    }

    register(): (req: ApiRequest, res: express.Response, next: express.NextFunction) => void {
        return async (req: ApiRequest, res: express.Response, next: express.NextFunction) => {
            req.session = new Session();
            await req.session.initSession(req);

            return next();
        };
    }
}


export default SessionMiddleware.instance;
