import Model from './Model';
import db    from '../helpers/DatabaseHelper';


class Enonce extends Model {
    static tableName: string = 'Enonce';

    enonceID: number = null;
    enonceName: string = '';
    enonceGitlabId: number = null;
    enonceGitlabLink: string = '';
    enonceGitlabCreationInfo: string = '';
    enonceGitlabLastInfo: string = '';
    enonceGitlabLastInfoTs: number = null;

    public async toJsonObject(lightVersion: boolean): Promise<Object> {
        const result = {
            'id'                : this.enonceID,
            'name'              : this.enonceName,
            'gitlabId'          : this.enonceGitlabId,
            'gitlabLink'        : this.enonceGitlabLink,
            'gitlabCreationInfo': this.enonceGitlabCreationInfo,
            'gitlabLastInfo'    : this.enonceGitlabLastInfo,
            'gitlabLastInfoTs'  : this.enonceGitlabLastInfoTs
        };

        return result;
    };

    public importFromJsonObject(jsonObject: any) {
        this.enonceID = jsonObject.id;
        this.enonceName = jsonObject.name;
        this.enonceGitlabId = jsonObject.gitlabId;
        this.enonceGitlabLink = jsonObject.gitlabLink;
        this.enonceGitlabCreationInfo = jsonObject.gitlabCreationInfo;
        this.enonceGitlabLastInfo = jsonObject.gitlabLastInfo;
        this.enonceGitlabLastInfoTs = jsonObject.gitlabLastInfoTs;
    }

    public toDb(): any {
        return {
            enonceName              : this.enonceName,
            enonceGitlabId          : this.enonceGitlabId,
            enonceGitlabLink        : this.enonceGitlabLink,
            enonceGitlabCreationInfo: this.enonceGitlabCreationInfo,
            enonceGitlabLastInfo    : this.enonceGitlabLastInfo,
            enonceGitlabLastInfoTs  : this.enonceGitlabLastInfoTs
        };
    }

    async create(): Promise<void> {
        const id = await db(Enonce.tableName).insert(this.toDb());
        this.enonceID = id[0];
    }

    update(): Promise<void> {
        return db(Enonce.tableName).where('enonceID', this.enonceID).update(this.toDb());
    }

    del(): Promise<void> {
        return db(Enonce.tableName).where('enonceID', this.enonceID).del();
    }
}


export default Enonce;
