import Model from './Model';
import db    from '../helpers/DatabaseHelper';


class EnonceStaff extends Model {
    static tableName: string = 'EnonceStaff';

    enonceID: number = null;
    userID: number = null;

    public async toJsonObject(lightVersion: boolean): Promise<Object> {
        const result = {
            'enonceID': this.enonceID,
            'userID'  : this.userID
        };

        return result;
    };

    public importFromJsonObject(jsonObject: any) {
        this.enonceID = jsonObject.enonceID;
        this.userID = jsonObject.userID;
    }

    public toDb(): any {
        return {
            enonceID: this.enonceID,
            userID  : this.userID
        };
    }

    create(): Promise<void> {
        return db(EnonceStaff.tableName).insert(this.toDb());
    }

    del(): Promise<void> {
        return db(EnonceStaff.tableName).where('enonceID', this.enonceID).andWhere('userID', this.userID).del();
    }
}


export default EnonceStaff;
