import db     from '../helpers/DatabaseHelper';
import Enonce from '../models/Enonce';


class EnonceManager {
    private static _instance: EnonceManager;

    private constructor() { }

    public static get instance(): EnonceManager {
        if ( !EnonceManager._instance ) {
            EnonceManager._instance = new EnonceManager();
        }

        return EnonceManager._instance;
    }

    createObjectFromRawSql(raw: any): Enonce {
        return Enonce.createFromSql(raw);
    }

    async getByName(name: string): Promise<Enonce | undefined> {
        const raw = await db<Enonce>(Enonce.tableName).where('enonceName', name).first();

        return raw ? this.createObjectFromRawSql(raw) : undefined;
    }

    getByGitlabLink(gitlabLink: string): Promise<Enonce | undefined> {
        const name = gitlabLink.replace('.git', '').split('/').pop();

        return this.getByName(name);
    }

    get(nameOrUrl: string): Promise<Enonce | undefined> {
        // We can use the same function for both name and url because the name is the last part of the url and the name extraction from the url doesn't corrupt the name
        return this.getByGitlabLink(nameOrUrl);
    }
}


export default EnonceManager.instance;
