import { Express }     from 'express-serve-static-core';
import ApiRequest      from '../models/ApiRequest';
import express         from 'express';
import { StatusCodes } from 'http-status-codes';
import EnonceManager   from '../managers/EnonceManager';


class ParamsCallbackManager {
    private static _instance: ParamsCallbackManager;

    private constructor() { }

    public static get instance(): ParamsCallbackManager {
        if ( !ParamsCallbackManager._instance ) {
            ParamsCallbackManager._instance = new ParamsCallbackManager();
        }

        return ParamsCallbackManager._instance;
    }

    protected listenParam(paramName: string, backend: Express, context: any, functionName: string, indexName: string) {
        backend.param(paramName, (req: ApiRequest, res: express.Response, next: express.NextFunction, id: string | number) => {
            (context[functionName] as (id: string | number) => Promise<any>)(id).then(result => {
                if ( result ) {
                    this.initBoundParams(req);
                    (req.boundParams as any)[indexName] = result;

                    next();
                } else {
                    req.session.sendResponse(res, StatusCodes.NOT_FOUND, {}, 'Param bounding failed: ' + paramName);
                }
            });
        });
    }

    initBoundParams(req: ApiRequest) {
        if ( !req.boundParams ) {
            req.boundParams = {
                enonce: null
            };
        }
    }

    register(backend: Express) {
        this.listenParam('enonceNameOrUrl', backend, EnonceManager, 'get', 'enonce');
    }
}


export default ParamsCallbackManager.instance;
