import Model from './Model';
import db    from '../helpers/DatabaseHelper';


class EnonceStaff extends Model {
    static tableName: string = 'EnonceStaff';

    enonceName: string = null;
    userID: number = null;

    public async toJsonObject(): Promise<Object> {
        const result = {
            'enonceName': this.enonceName,
            'userID'    : this.userID
        };

        return result;
    };

    public importFromJsonObject(jsonObject: any) {
        this.enonceName = jsonObject.enonceName;
        this.userID = jsonObject.userID;
    }

    public toDb(): any {
        return {
            enonceName: this.enonceName,
            userID    : this.userID
        };
    }

    async create(): Promise<EnonceStaff> {
        await db(EnonceStaff.tableName).insert(this.toDb());
        return this;
    }

    del(): Promise<void> {
        return db(EnonceStaff.tableName).where('enonceName', this.enonceName).andWhere('userID', this.userID).del();
    }
}


export default EnonceStaff;
