type Constructor<T> = new (...args: any[]) => T;


abstract class Model extends Object {
    static tableName: string = null;

    static createFromSql<T extends Object>(this: Constructor<T>, obj: any): T {
        const result = new this();

        Object.getOwnPropertyNames(obj).forEach(property => {
            if ( result.hasOwnProperty(property) ) {
                (result as any)[property] = obj[property];
            }
        });
        return result;
    }

    public abstract toJsonObject(): Promise<Object>
}


export default Model;
