import Model from './Model';
import db    from '../helpers/DatabaseHelper';


class Enonce extends Model {
    static tableName: string = 'Enonce';

    enonceName: string = '';
    enonceGitlabId: number = null;
    enonceGitlabLink: string = '';
    enonceGitlabCreationInfo: string = '';
    enonceGitlabLastInfo: string = '';
    enonceGitlabLastInfoTs: number = null;

    public async toJsonObject(): Promise<Object> {
        const result = {
            'name'              : this.enonceName,
            'gitlabId'          : this.enonceGitlabId,
            'gitlabLink'        : this.enonceGitlabLink,
            'gitlabCreationInfo': JSON.parse(this.enonceGitlabCreationInfo),
            'gitlabLastInfo'    : JSON.parse(this.enonceGitlabLastInfo),
            'gitlabLastInfoTs'  : this.enonceGitlabLastInfoTs
        };

        return result;
    };

    public importFromJsonObject(jsonObject: any) {
        this.enonceName = jsonObject.name;
        this.enonceGitlabId = jsonObject.gitlabId;
        this.enonceGitlabLink = jsonObject.gitlabLink;
        this.enonceGitlabCreationInfo = jsonObject.gitlabCreationInfo;
        this.enonceGitlabLastInfo = jsonObject.gitlabLastInfo;
        this.enonceGitlabLastInfoTs = jsonObject.gitlabLastInfoTs;
    }

    public toDb(): any {
        return {
            enonceName              : this.enonceName,
            enonceGitlabId          : this.enonceGitlabId,
            enonceGitlabLink        : this.enonceGitlabLink,
            enonceGitlabCreationInfo: this.enonceGitlabCreationInfo,
            enonceGitlabLastInfo    : this.enonceGitlabLastInfo,
            enonceGitlabLastInfoTs  : this.enonceGitlabLastInfoTs
        };
    }

    async create(): Promise<Enonce> {
        await db(Enonce.tableName).insert(this.toDb());
        return this;
    }

    update(): Promise<void> {
        return db(Enonce.tableName).where('enonceName', this.enonceName).update(this.toDb());
    }

    del(): Promise<void> {
        return db(Enonce.tableName).where('enonceName', this.enonceName).del();
    }
}


export default Enonce;
