import { Express }   from 'express-serve-static-core';
import RoutesManager from '../express/RoutesManager';
import BaseRoutes    from './BaseRoutes';
import SessionRoutes from './SessionRoutes';
import EnonceRoutes  from './EnonceRoutes';
import GitlabRoutes  from './GitlabRoutes';


class AdminRoutesManager implements RoutesManager {
    private static _instance: AdminRoutesManager;

    private constructor() { }

    public static get instance(): AdminRoutesManager {
        if ( !AdminRoutesManager._instance ) {
            AdminRoutesManager._instance = new AdminRoutesManager();
        }

        return AdminRoutesManager._instance;
    }

    registerOnBackend(backend: Express) {
        BaseRoutes.registerOnBackend(backend);
        SessionRoutes.registerOnBackend(backend);
        EnonceRoutes.registerOnBackend(backend);
        GitlabRoutes.registerOnBackend(backend);
    }
}


export default AdminRoutesManager.instance;
