import { Express }     from 'express-serve-static-core';
import ApiRequest      from '../models/ApiRequest';
import express         from 'express';
import { StatusCodes } from 'http-status-codes';
import RoutesManager   from '../express/RoutesManager';


class BaseRoutes implements RoutesManager {
    private static _instance: BaseRoutes;

    private constructor() { }

    public static get instance(): BaseRoutes {
        if ( !BaseRoutes._instance ) {
            BaseRoutes._instance = new BaseRoutes();
        }

        return BaseRoutes._instance;
    }

    registerOnBackend(backend: Express) {
        backend.get('/', (req: ApiRequest, res: express.Response) => { res.status(StatusCodes.OK).end(); });
        backend.get('/health_check', (req: ApiRequest, res: express.Response) => { res.status(StatusCodes.OK).end(); });
    }
}


export default BaseRoutes.instance;
