/*
  Warnings:

  - A unique constraint covering the columns `[secret]` on the table `Exercice` will be added. If there are existing duplicate values, this will fail.
  - Added the required column `secret` to the `Exercice` table without a default value. This is not possible if the table is not empty.

*/
-- AlterTable
ALTER TABLE `Exercice` ADD COLUMN `secret` CHAR(36) NOT NULL;

-- Add the secret to the existing exercices
-- Source of the function : https://stackoverflow.com/questions/32965743/how-to-generate-a-uuidv4-in-mysql/32965744#32965744
-- Change delimiter so that the function body doesn't end the function declaration
DROP FUNCTION IF EXISTS uuid_v4;
CREATE FUNCTION uuid_v4()
    RETURNS CHAR(36) NO SQL
BEGIN
    -- Generate 8 2-byte strings that we will combine into a UUIDv4
    SET @h1 = LPAD(HEX(FLOOR(RAND() * 0xffff)), 4, '0');
    SET @h2 = LPAD(HEX(FLOOR(RAND() * 0xffff)), 4, '0');
    SET @h3 = LPAD(HEX(FLOOR(RAND() * 0xffff)), 4, '0');
    SET @h6 = LPAD(HEX(FLOOR(RAND() * 0xffff)), 4, '0');
    SET @h7 = LPAD(HEX(FLOOR(RAND() * 0xffff)), 4, '0');
    SET @h8 = LPAD(HEX(FLOOR(RAND() * 0xffff)), 4, '0');

    -- 4th section will start with a 4 indicating the version
    SET @h4 = CONCAT('4', LPAD(HEX(FLOOR(RAND() * 0x0fff)), 3, '0'));

    -- 5th section first half-byte can only be 8, 9 A or B
    SET @h5 = CONCAT(HEX(FLOOR(RAND() * 4 + 8)),
                     LPAD(HEX(FLOOR(RAND() * 0x0fff)), 3, '0'));

    -- Build the complete UUID
    RETURN LOWER(CONCAT(
            @h1, @h2, '-', @h3, '-', @h4, '-', @h5, '-', @h6, @h7, @h8
        ));
END;

UPDATE `Exercice` SET `secret` = uuid_v4();

-- CreateIndex
CREATE UNIQUE INDEX `Exercice_secret_key` ON `Exercice`(`secret`);
