-- RenameTable
RENAME TABLE `Enonce` TO `Assignment`;

-- RenameTable
RENAME TABLE `Exercice` TO `Exercise`;

-- RenameTable
RENAME TABLE `_EnonceToUser` TO `_AssignmentToUser`;

-- RenameTable
RENAME TABLE `_ExerciceToUser` TO `_ExerciseToUser`;

-- AlterTable
ALTER TABLE `Exercise` RENAME COLUMN `enonceName` TO `assignmentName`;

-- AlterTable
ALTER TABLE `Result` RENAME COLUMN `exerciceId` TO `exerciseId`;

-- RenameIndex
ALTER TABLE `Exercise` RENAME INDEX `Exercice_secret_key` TO `Exercise_secret_key`;

-- RenameIndex
ALTER TABLE `Exercise` RENAME INDEX `Exercice_enonceName_fkey` TO `Exercise_assignmentName_fkey`;

-- RenameIndex
ALTER TABLE `_ExerciseToUser` RENAME INDEX `_ExerciceToUser_AB_unique` TO `_ExerciseToUser_AB_unique`;

-- RenameIndex
ALTER TABLE `_ExerciseToUser` RENAME INDEX `_ExerciceToUser_B_index` TO `_ExerciseToUser_B_index`;

-- RenameIndex
ALTER TABLE `_AssignmentToUser` RENAME INDEX `_EnonceToUser_AB_unique` TO `_AssignmentToUser_AB_unique`;

-- RenameIndex
ALTER TABLE `_AssignmentToUser` RENAME INDEX `_EnonceToUser_B_index` TO `_AssignmentToUser_B_index`;

-- Rename foreign key
ALTER TABLE `Exercise`
    DROP FOREIGN KEY `Exercice_enonceName_fkey`,
    ADD CONSTRAINT `Exercise_assignmentName_fkey` FOREIGN KEY (`assignmentName`) REFERENCES `Assignment`(`name`) ON DELETE NO ACTION ON UPDATE CASCADE;

-- Rename foreign key
ALTER TABLE `Result`
    DROP FOREIGN KEY `Result_exerciceId_fkey`,
    ADD CONSTRAINT `Result_exerciseId_fkey` FOREIGN KEY (`exerciseId`) REFERENCES `Exercise`(`id`) ON DELETE CASCADE ON UPDATE CASCADE;

-- Rename foreign key
ALTER TABLE `_AssignmentToUser`
    DROP FOREIGN KEY `_EnonceToUser_A_fkey`,
    ADD CONSTRAINT `_AssignmentToUser_A_fkey` FOREIGN KEY (`A`) REFERENCES `Assignment`(`name`) ON DELETE CASCADE ON UPDATE CASCADE;

-- Rename foreign key
ALTER TABLE `_AssignmentToUser`
    DROP FOREIGN KEY `_EnonceToUser_B_fkey`,
    ADD CONSTRAINT `_AssignmentToUser_B_fkey` FOREIGN KEY (`B`) REFERENCES `User`(`id`) ON DELETE CASCADE ON UPDATE CASCADE;

-- Rename foreign key
ALTER TABLE `_ExerciseToUser`
    DROP FOREIGN KEY `_ExerciceToUser_A_fkey`,
    ADD CONSTRAINT `_ExerciseToUser_A_fkey` FOREIGN KEY (`A`) REFERENCES `Exercise`(`id`) ON DELETE CASCADE ON UPDATE CASCADE;

-- Rename foreign key
ALTER TABLE `_ExerciseToUser`
    DROP FOREIGN KEY `_ExerciceToUser_B_fkey`,
    ADD CONSTRAINT `_ExerciseToUser_B_fkey` FOREIGN KEY (`B`) REFERENCES `User`(`id`) ON DELETE CASCADE ON UPDATE CASCADE;