import { SubmissionTag }           from '@prisma/client';
import db                        from '../helpers/DatabaseHelper';

class TagSubmitManager {
	async get(name: string | undefined = undefined): Promise<SubmissionTag | undefined> {
        return await db.submissionTag.findUnique({
                                                where  : {
                                                    name: name
                                                }
                                            }) as unknown as SubmissionTag ?? undefined;
    }
}


export default new TagSubmitManager();

