import { Express }       from 'express-serve-static-core';
import express           from 'express';
import { StatusCodes }   from 'http-status-codes';
import ExerciseManager   from '../managers/ExerciseManager';
import AssignmentManager from '../managers/AssignmentManager';
import TagManager        from '../managers/TagManager';
import TagSubmitManager  from '../managers/TagSubmitManager';


type GetFunction = (id: string | number, ...args: Array<unknown>) => Promise<unknown>


class ParamsCallbackManager {
    protected listenParam(paramName: string, backend: Express, getFunction: GetFunction, args: Array<unknown>, indexName: string) {
        backend.param(paramName, (req: express.Request, res: express.Response, next: express.NextFunction, id: string | number) => {
            getFunction(id, ...args).then(result => {
                if ( result ) {
                    this.initBoundParams(req);
                    (req.boundParams as Record<string, unknown>)[indexName] = result;

                    next();
                } else {
                    req.session.sendResponse(res, StatusCodes.NOT_FOUND, {}, 'Param bounding failed: ' + paramName);
                }
            });
        });
    }

    initBoundParams(req: express.Request) {
        if ( !req.boundParams ) {
            req.boundParams = {
                assignment: undefined,
                exercise  : undefined,
                tag       : undefined 
            };
        }
    }

    registerOnBackend(backend: Express) {
        this.listenParam('assignmentNameOrUrl', backend, (AssignmentManager.get as GetFunction).bind(AssignmentManager), [ {
            exercises: true,
            staff    : true
        } ], 'assignment');

        this.listenParam('exerciseIdOrUrl', backend, (ExerciseManager.get as GetFunction).bind(ExerciseManager), [ {
            assignment: true,
            members   : true,
            results   : true
        } ], 'exercise');
        
        this.listenParam('tagId', backend, (TagManager.get as GetFunction).bind(TagManager), [ {

        } ], 'tags');

        this.listenParam('tagProposalName', backend, (TagSubmitManager.get as GetFunction).bind(TagSubmitManager), [ {
 
        } ], 'tags');
    }
}


export default new ParamsCallbackManager();
