import { Express }                 from 'express-serve-static-core';
import express, { RequestHandler } from 'express';
import RoutesManager               from '../express/RoutesManager.js';
import SecurityMiddleware          from '../middlewares/SecurityMiddleware.js';
import SecurityCheckType           from '../types/SecurityCheckType.js';
import GitlabManager               from '../managers/GitlabManager.js';


class GitlabRoutes implements RoutesManager {
    registerOnBackend(backend: Express) {
        backend.get('/gitlab/project/:gitlabProjectIdOrNamespace/checkTemplateAccess', SecurityMiddleware.check(true, SecurityCheckType.TEACHING_STAFF), this.checkTemplateAccess.bind(this) as RequestHandler);
    }

    private async checkTemplateAccess(req: express.Request, res: express.Response) {
        const gitlabProjectIdOrNamespace: string = req.params.gitlabProjectIdOrNamespace;

        await GitlabManager.checkTemplateAccess(gitlabProjectIdOrNamespace, req, res);
    }
}


export default new GitlabRoutes();
