import path from 'node:path';


if ( process.env.NODE_ENV && process.env.NODE_ENV === 'production' ) {
    const myEnv = require('dotenv').config();
    require('dotenv-expand').expand(myEnv);
} else {
    require('dotenv').config({ path: path.join(__dirname, '../.env.keys') });
    const myEnv = require('dotenv').config({ DOTENV_KEY: process.env.DOTENV_KEY_DEVELOPMENT });
    require('dotenv-expand').expand(myEnv);
}

require('./shared/helpers/TypeScriptExtensions'); // ATTENTION : This line MUST be after the dotenv.config() calls
