import { Prisma, UserRole } from '@prisma/client';
import LazyVal              from '../../../shared/helpers/LazyVal';
import GitlabUser           from '../../../shared/types/Gitlab/GitlabUser';
import GitlabManager        from '../../../managers/GitlabManager';


export default Prisma.defineExtension(client => {
    return client.$extends({
                               result: {
                                   user: {
                                       isTeachingStaff: {
                                           needs: {
                                               role: true
                                           },
                                           compute(user) {
                                               return user.role == UserRole.TEACHING_STAFF || user.role == UserRole.ADMIN;
                                           }
                                       },
                                       isAdmin        : {
                                           needs: {
                                               role: true
                                           },
                                           compute(user) {
                                               return user.role == UserRole.ADMIN;
                                           }
                                       },
                                       gitlabProfile  : {
                                           compute(user) {
                                               return new LazyVal<GitlabUser | undefined>(() => {
                                                   return GitlabManager.getUserById(user.id);
                                               });
                                           }
                                       }
                                   }
                               }
                           });
});