import { Express }       from 'express-serve-static-core';
import express           from 'express';
import { StatusCodes }   from 'http-status-codes';
import ExerciseManager   from '../managers/ExerciseManager';
import AssignmentManager from '../managers/AssignmentManager';


type GetFunction = (id: string | number, ...args: Array<any>) => Promise<any>


class ParamsCallbackManager {
    protected listenParam(paramName: string, backend: Express, getFunction: GetFunction, args: Array<any>, indexName: string) {
        backend.param(paramName, (req: express.Request, res: express.Response, next: express.NextFunction, id: string | number) => {
            getFunction(id, ...args).then(result => {
                if ( result ) {
                    this.initBoundParams(req);
                    (req.boundParams as any)[indexName] = result;

                    next();
                } else {
                    req.session.sendResponse(res, StatusCodes.NOT_FOUND, {}, 'Param bounding failed: ' + paramName);
                }
            });
        });
    }

    initBoundParams(req: express.Request) {
        if ( !req.boundParams ) {
            req.boundParams = {
                assignment: undefined,
                exercise  : undefined
            };
        }
    }

    register(backend: Express) {
        this.listenParam('assignmentNameOrUrl', backend, (AssignmentManager.get as GetFunction).bind(AssignmentManager), [ {
            exercises: true,
            staff    : true
        } ], 'assignment');

        this.listenParam('exerciseId', backend, (ExerciseManager.get as GetFunction).bind(ExerciseManager), [ {
            assignment: true,
            members   : true,
            results   : true
        } ], 'exercise');
    }
}


export default new ParamsCallbackManager();
