import express from 'express';
import Session from '../controllers/Session';


class SessionMiddleware {
    register(): (req: express.Request, res: express.Response, next: express.NextFunction) => void {
        return async (req: express.Request, res: express.Response, next: express.NextFunction) => {
            req.session = new Session();
            await req.session.initSession(req, res);

            return next();
        };
    }
}


export default new SessionMiddleware();
