import { Express }     from 'express-serve-static-core';
import express         from 'express';
import { StatusCodes } from 'http-status-codes';
import RoutesManager   from '../express/RoutesManager';


class BaseRoutes implements RoutesManager {
    registerOnBackend(backend: Express) {
        backend.get('/', (req: express.Request, res: express.Response) => { res.status(StatusCodes.OK).end(); });
        backend.get('/health_check', (req: express.Request, res: express.Response) => { res.status(StatusCodes.OK).end(); });
    }
}


export default new BaseRoutes();
