require('../src/InitialImports'); // ATTENTION : These lines MUST be the first of this file

import * as process from 'process';
import SharedConfig from '../src/shared/config/SharedConfig';
import { UserRole } from '@prisma/client';
import logger       from '../src/shared/logging/WinstonLogger';
import db           from '../src/helpers/DatabaseHelper';


async function main() {
    await users();
    await assignments();
    await exercises();
    await results();
}

main().then(async () => {
    await db.$disconnect();
}).catch(async e => {
    logger.error(e);
    await db.$disconnect();
    process.exit(1);
});

//----------------------------------------------------------------------------------------------------------------------------------------------------------

async function users() {
    await db.user.upsert({
                             where : { id: 142 },
                             update: {},
                             create: {
                                 id            : 142,
                                 gitlabUsername: 'michael.minelli',
                                 gitlabLastInfo: {},
                                 role          : UserRole.ADMIN,
                                 deleted       : false
                             }
                         });
    await db.user.upsert({
                             where : { id: 133 },
                             update: {},
                             create: {
                                 id            : 133,
                                 gitlabUsername: 'orestis.malaspin',
                                 gitlabLastInfo: {},
                                 role          : UserRole.ADMIN,
                                 deleted       : false
                             }
                         });
    if ( !SharedConfig.production ) {
        await db.user.upsert({
                                 where : { id: 627 },
                                 update: {},
                                 create: {
                                     id            : 627,
                                     gitlabUsername: 'kelly.nguyen',
                                     gitlabLastInfo: {},
                                     role          : UserRole.ADMIN,
                                     deleted       : false
                                 }
                             });
        await db.user.upsert({
                                 where : { id: 623 },
                                 update: {},
                                 create: {
                                     id            : 623,
                                     gitlabUsername: 'bedran.sezer',
                                     gitlabLastInfo: {},
                                     role          : UserRole.ADMIN,
                                     deleted       : false
                                 }
                             });
        await db.user.upsert({
                                 where : { id: 642 },
                                 update: {},
                                 create: {
                                     id            : 642,
                                     gitlabUsername: 'vincent.steinman',
                                     gitlabLastInfo: {},
                                     role          : UserRole.ADMIN,
                                     deleted       : false
                                 }
                             });
    }
}

async function assignments() {
    if ( !SharedConfig.production ) {
        await db.assignment.upsert({
                                       where : { name: 'c_hello_world' },
                                       update: {},
                                       create: {
                                           name              : 'c_hello_world',
                                           gitlabId          : 13862,
                                           gitlabLink        : 'https://gitedu.hesge.ch/dojodev/assignment/c_hello_world',
                                           gitlabCreationInfo: {
                                               'id'                                              : 13862,
                                               'description'                                     : 'Dojo assignment repository.\n\nName of the assignment: c_hello_world',
                                               'name'                                            : 'c_hello_world',
                                               'name_with_namespace'                             : 'DojoDev / Assignment / c_hello_world',
                                               'path'                                            : 'c_hello_world',
                                               'path_with_namespace'                             : 'dojodev/assignment/c_hello_world',
                                               'created_at'                                      : '2023-11-02T22:20:15.239+01:00',
                                               'default_branch'                                  : 'main',
                                               'tag_list'                                        : [],
                                               'topics'                                          : [],
                                               'ssh_url_to_repo'                                 : 'ssh://git@ssh.hesge.ch:10572/dojodev/assignment/c_hello_world.git',
                                               'http_url_to_repo'                                : 'https://gitedu.hesge.ch/dojodev/assignment/c_hello_world.git',
                                               'web_url'                                         : 'https://gitedu.hesge.ch/dojodev/assignment/c_hello_world',
                                               'readme_url'                                      : null,
                                               'forks_count'                                     : 0,
                                               'avatar_url'                                      : null,
                                               'star_count'                                      : 0,
                                               'last_activity_at'                                : '2023-11-02T22:20:15.239+01:00',
                                               'namespace'                                       : {
                                                   'id'        : 14190,
                                                   'name'      : 'Assignment',
                                                   'path'      : 'assignment',
                                                   'kind'      : 'group',
                                                   'full_path' : 'dojodev/assignment',
                                                   'parent_id' : 14189,
                                                   'avatar_url': null,
                                                   'web_url'   : 'https://gitedu.hesge.ch/groups/dojodev/assignment'
                                               },
                                               '_links'                                          : {
                                                   'self'          : 'https://gitedu.hesge.ch/api/v4/projects/13862',
                                                   'issues'        : 'https://gitedu.hesge.ch/api/v4/projects/13862/issues',
                                                   'merge_requests': 'https://gitedu.hesge.ch/api/v4/projects/13862/merge_requests',
                                                   'repo_branches' : 'https://gitedu.hesge.ch/api/v4/projects/13862/repository/branches',
                                                   'labels'        : 'https://gitedu.hesge.ch/api/v4/projects/13862/labels',
                                                   'events'        : 'https://gitedu.hesge.ch/api/v4/projects/13862/events',
                                                   'members'       : 'https://gitedu.hesge.ch/api/v4/projects/13862/members',
                                                   'cluster_agents': 'https://gitedu.hesge.ch/api/v4/projects/13862/cluster_agents'
                                               },
                                               'packages_enabled'                                : true,
                                               'empty_repo'                                      : true,
                                               'archived'                                        : false,
                                               'visibility'                                      : 'private',
                                               'resolve_outdated_diff_discussions'               : false,
                                               'container_expiration_policy'                     : {
                                                   'cadence'        : '1d',
                                                   'enabled'        : false,
                                                   'keep_n'         : 10,
                                                   'older_than'     : '90d',
                                                   'name_regex'     : '.*',
                                                   'name_regex_keep': null,
                                                   'next_run_at'    : '2023-11-03T22:20:15.275+01:00'
                                               },
                                               'issues_enabled'                                  : true,
                                               'merge_requests_enabled'                          : true,
                                               'wiki_enabled'                                    : false,
                                               'jobs_enabled'                                    : true,
                                               'snippets_enabled'                                : true,
                                               'container_registry_enabled'                      : true,
                                               'service_desk_enabled'                            : false,
                                               'service_desk_address'                            : null,
                                               'can_create_merge_request_in'                     : true,
                                               'issues_access_level'                             : 'enabled',
                                               'repository_access_level'                         : 'enabled',
                                               'merge_requests_access_level'                     : 'enabled',
                                               'forking_access_level'                            : 'enabled',
                                               'wiki_access_level'                               : 'disabled',
                                               'builds_access_level'                             : 'enabled',
                                               'snippets_access_level'                           : 'enabled',
                                               'pages_access_level'                              : 'private',
                                               'analytics_access_level'                          : 'enabled',
                                               'container_registry_access_level'                 : 'enabled',
                                               'security_and_compliance_access_level'            : 'private',
                                               'releases_access_level'                           : 'enabled',
                                               'environments_access_level'                       : 'enabled',
                                               'feature_flags_access_level'                      : 'enabled',
                                               'infrastructure_access_level'                     : 'enabled',
                                               'monitor_access_level'                            : 'enabled',
                                               'emails_disabled'                                 : null,
                                               'shared_runners_enabled'                          : true,
                                               'lfs_enabled'                                     : true,
                                               'creator_id'                                      : 1076,
                                               'import_url'                                      : 'https://gitedu.hesge.ch/dojodev/template/empty_template.git',
                                               'import_type'                                     : 'git',
                                               'import_status'                                   : 'scheduled',
                                               'import_error'                                    : null,
                                               'open_issues_count'                               : 0,
                                               'description_html'                                : '<p data-sourcepos="1:1-1:27" dir="auto">Dojo assignment repository.</p>\n<p data-sourcepos="3:1-3:37" dir="auto">Name of the assignment: c_hello_world</p>',
                                               'updated_at'                                      : '2023-11-02T22:20:15.239+01:00',
                                               'ci_default_git_depth'                            : 20,
                                               'ci_forward_deployment_enabled'                   : true,
                                               'ci_job_token_scope_enabled'                      : false,
                                               'ci_separated_caches'                             : true,
                                               'ci_allow_fork_pipelines_to_run_in_parent_project': true,
                                               'build_git_strategy'                              : 'fetch',
                                               'keep_latest_artifact'                            : true,
                                               'restrict_user_defined_variables'                 : false,
                                               'runners_token'                                   : 'GR1348941TZKVMY5xH7ecxwLxn1x7',
                                               'runner_token_expiration_interval'                : null,
                                               'group_runners_enabled'                           : true,
                                               'auto_cancel_pending_pipelines'                   : 'enabled',
                                               'build_timeout'                                   : 3600,
                                               'auto_devops_enabled'                             : false,
                                               'auto_devops_deploy_strategy'                     : 'continuous',
                                               'ci_config_path'                                  : '',
                                               'public_jobs'                                     : true,
                                               'shared_with_groups'                              : [],
                                               'only_allow_merge_if_pipeline_succeeds'           : false,
                                               'allow_merge_on_skipped_pipeline'                 : null,
                                               'request_access_enabled'                          : true,
                                               'only_allow_merge_if_all_discussions_are_resolved': false,
                                               'remove_source_branch_after_merge'                : true,
                                               'printing_merge_request_link_enabled'             : true,
                                               'merge_method'                                    : 'merge',
                                               'squash_option'                                   : 'default_off',
                                               'enforce_auth_checks_on_uploads'                  : true,
                                               'suggestion_commit_message'                       : null,
                                               'merge_commit_template'                           : null,
                                               'squash_commit_template'                          : null,
                                               'issue_branch_template'                           : null,
                                               'autoclose_referenced_issues'                     : true
                                           },
                                           gitlabLastInfo    : {
                                               'id'                                              : 13862,
                                               'description'                                     : 'Dojo assignment repository.\n\nName of the assignment: c_hello_world',
                                               'name'                                            : 'c_hello_world',
                                               'name_with_namespace'                             : 'DojoDev / Assignment / c_hello_world',
                                               'path'                                            : 'c_hello_world',
                                               'path_with_namespace'                             : 'dojodev/assignment/c_hello_world',
                                               'created_at'                                      : '2023-11-02T22:20:15.239+01:00',
                                               'default_branch'                                  : 'main',
                                               'tag_list'                                        : [],
                                               'topics'                                          : [],
                                               'ssh_url_to_repo'                                 : 'ssh://git@ssh.hesge.ch:10572/dojodev/assignment/c_hello_world.git',
                                               'http_url_to_repo'                                : 'https://gitedu.hesge.ch/dojodev/assignment/c_hello_world.git',
                                               'web_url'                                         : 'https://gitedu.hesge.ch/dojodev/assignment/c_hello_world',
                                               'readme_url'                                      : null,
                                               'forks_count'                                     : 0,
                                               'avatar_url'                                      : null,
                                               'star_count'                                      : 0,
                                               'last_activity_at'                                : '2023-11-02T22:20:15.239+01:00',
                                               'namespace'                                       : {
                                                   'id'        : 14190,
                                                   'name'      : 'Assignment',
                                                   'path'      : 'assignment',
                                                   'kind'      : 'group',
                                                   'full_path' : 'dojodev/assignment',
                                                   'parent_id' : 14189,
                                                   'avatar_url': null,
                                                   'web_url'   : 'https://gitedu.hesge.ch/groups/dojodev/assignment'
                                               },
                                               '_links'                                          : {
                                                   'self'          : 'https://gitedu.hesge.ch/api/v4/projects/13862',
                                                   'issues'        : 'https://gitedu.hesge.ch/api/v4/projects/13862/issues',
                                                   'merge_requests': 'https://gitedu.hesge.ch/api/v4/projects/13862/merge_requests',
                                                   'repo_branches' : 'https://gitedu.hesge.ch/api/v4/projects/13862/repository/branches',
                                                   'labels'        : 'https://gitedu.hesge.ch/api/v4/projects/13862/labels',
                                                   'events'        : 'https://gitedu.hesge.ch/api/v4/projects/13862/events',
                                                   'members'       : 'https://gitedu.hesge.ch/api/v4/projects/13862/members',
                                                   'cluster_agents': 'https://gitedu.hesge.ch/api/v4/projects/13862/cluster_agents'
                                               },
                                               'packages_enabled'                                : true,
                                               'empty_repo'                                      : true,
                                               'archived'                                        : false,
                                               'visibility'                                      : 'private',
                                               'resolve_outdated_diff_discussions'               : false,
                                               'container_expiration_policy'                     : {
                                                   'cadence'        : '1d',
                                                   'enabled'        : false,
                                                   'keep_n'         : 10,
                                                   'older_than'     : '90d',
                                                   'name_regex'     : '.*',
                                                   'name_regex_keep': null,
                                                   'next_run_at'    : '2023-11-03T22:20:15.275+01:00'
                                               },
                                               'issues_enabled'                                  : true,
                                               'merge_requests_enabled'                          : true,
                                               'wiki_enabled'                                    : false,
                                               'jobs_enabled'                                    : true,
                                               'snippets_enabled'                                : true,
                                               'container_registry_enabled'                      : true,
                                               'service_desk_enabled'                            : false,
                                               'service_desk_address'                            : null,
                                               'can_create_merge_request_in'                     : true,
                                               'issues_access_level'                             : 'enabled',
                                               'repository_access_level'                         : 'enabled',
                                               'merge_requests_access_level'                     : 'enabled',
                                               'forking_access_level'                            : 'enabled',
                                               'wiki_access_level'                               : 'disabled',
                                               'builds_access_level'                             : 'enabled',
                                               'snippets_access_level'                           : 'enabled',
                                               'pages_access_level'                              : 'private',
                                               'analytics_access_level'                          : 'enabled',
                                               'container_registry_access_level'                 : 'enabled',
                                               'security_and_compliance_access_level'            : 'private',
                                               'releases_access_level'                           : 'enabled',
                                               'environments_access_level'                       : 'enabled',
                                               'feature_flags_access_level'                      : 'enabled',
                                               'infrastructure_access_level'                     : 'enabled',
                                               'monitor_access_level'                            : 'enabled',
                                               'emails_disabled'                                 : null,
                                               'shared_runners_enabled'                          : true,
                                               'lfs_enabled'                                     : true,
                                               'creator_id'                                      : 1076,
                                               'import_url'                                      : 'https://gitedu.hesge.ch/dojodev/template/empty_template.git',
                                               'import_type'                                     : 'git',
                                               'import_status'                                   : 'scheduled',
                                               'import_error'                                    : null,
                                               'open_issues_count'                               : 0,
                                               'description_html'                                : '<p data-sourcepos="1:1-1:27" dir="auto">Dojo assignment repository.</p>\n<p data-sourcepos="3:1-3:37" dir="auto">Name of the assignment: c_hello_world</p>',
                                               'updated_at'                                      : '2023-11-02T22:20:15.239+01:00',
                                               'ci_default_git_depth'                            : 20,
                                               'ci_forward_deployment_enabled'                   : true,
                                               'ci_job_token_scope_enabled'                      : false,
                                               'ci_separated_caches'                             : true,
                                               'ci_allow_fork_pipelines_to_run_in_parent_project': true,
                                               'build_git_strategy'                              : 'fetch',
                                               'keep_latest_artifact'                            : true,
                                               'restrict_user_defined_variables'                 : false,
                                               'runners_token'                                   : 'GR1348941TZKVMY5xH7ecxwLxn1x7',
                                               'runner_token_expiration_interval'                : null,
                                               'group_runners_enabled'                           : true,
                                               'auto_cancel_pending_pipelines'                   : 'enabled',
                                               'build_timeout'                                   : 3600,
                                               'auto_devops_enabled'                             : false,
                                               'auto_devops_deploy_strategy'                     : 'continuous',
                                               'ci_config_path'                                  : '',
                                               'public_jobs'                                     : true,
                                               'shared_with_groups'                              : [],
                                               'only_allow_merge_if_pipeline_succeeds'           : false,
                                               'allow_merge_on_skipped_pipeline'                 : null,
                                               'request_access_enabled'                          : true,
                                               'only_allow_merge_if_all_discussions_are_resolved': false,
                                               'remove_source_branch_after_merge'                : true,
                                               'printing_merge_request_link_enabled'             : true,
                                               'merge_method'                                    : 'merge',
                                               'squash_option'                                   : 'default_off',
                                               'enforce_auth_checks_on_uploads'                  : true,
                                               'suggestion_commit_message'                       : null,
                                               'merge_commit_template'                           : null,
                                               'squash_commit_template'                          : null,
                                               'issue_branch_template'                           : null,
                                               'autoclose_referenced_issues'                     : true
                                           },
                                           gitlabLastInfoDate: new Date('2021-10-14T14:20:15.239Z'),
                                           published         : false
                                       }
                                   });
        await db.assignment.upsert({
                                       where : { name: 'Technique de compilation - TP' },
                                       update: {},
                                       create: {
                                           name              : 'Technique de compilation - TP',
                                           gitlabId          : 13893,
                                           gitlabLink        : 'https://gitedu.hesge.ch/dojodev/assignment/technique-de-compilation-tp',
                                           gitlabCreationInfo: {
                                               'id'                                              : 13893,
                                               'description'                                     : 'Dojo assignment repository.\n\nName of the assignment: Technique de compilation - TP',
                                               'name'                                            : 'Technique de compilation - TP',
                                               'name_with_namespace'                             : 'DojoDev / Assignment / Technique de compilation - TP',
                                               'path'                                            : 'technique-de-compilation-tp',
                                               'path_with_namespace'                             : 'dojodev/assignment/technique-de-compilation-tp',
                                               'created_at'                                      : '2023-11-07T21:35:48.454+01:00',
                                               'default_branch'                                  : 'main',
                                               'tag_list'                                        : [],
                                               'topics'                                          : [],
                                               'ssh_url_to_repo'                                 : 'ssh://git@ssh.hesge.ch:10572/dojodev/assignment/technique-de-compilation-tp.git',
                                               'http_url_to_repo'                                : 'https://gitedu.hesge.ch/dojodev/assignment/technique-de-compilation-tp.git',
                                               'web_url'                                         : 'https://gitedu.hesge.ch/dojodev/assignment/technique-de-compilation-tp',
                                               'readme_url'                                      : null,
                                               'forks_count'                                     : 0,
                                               'avatar_url'                                      : null,
                                               'star_count'                                      : 0,
                                               'last_activity_at'                                : '2023-11-07T21:35:48.454+01:00',
                                               'namespace'                                       : {
                                                   'id'        : 14190,
                                                   'name'      : 'Assignment',
                                                   'path'      : 'assignment',
                                                   'kind'      : 'group',
                                                   'full_path' : 'dojodev/assignment',
                                                   'parent_id' : 14189,
                                                   'avatar_url': null,
                                                   'web_url'   : 'https://gitedu.hesge.ch/groups/dojodev/assignment'
                                               },
                                               '_links'                                          : {
                                                   'self'          : 'https://gitedu.hesge.ch/api/v4/projects/13893',
                                                   'issues'        : 'https://gitedu.hesge.ch/api/v4/projects/13893/issues',
                                                   'merge_requests': 'https://gitedu.hesge.ch/api/v4/projects/13893/merge_requests',
                                                   'repo_branches' : 'https://gitedu.hesge.ch/api/v4/projects/13893/repository/branches',
                                                   'labels'        : 'https://gitedu.hesge.ch/api/v4/projects/13893/labels',
                                                   'events'        : 'https://gitedu.hesge.ch/api/v4/projects/13893/events',
                                                   'members'       : 'https://gitedu.hesge.ch/api/v4/projects/13893/members',
                                                   'cluster_agents': 'https://gitedu.hesge.ch/api/v4/projects/13893/cluster_agents'
                                               },
                                               'packages_enabled'                                : true,
                                               'empty_repo'                                      : true,
                                               'archived'                                        : false,
                                               'visibility'                                      : 'private',
                                               'resolve_outdated_diff_discussions'               : false,
                                               'container_expiration_policy'                     : {
                                                   'cadence'        : '1d',
                                                   'enabled'        : false,
                                                   'keep_n'         : 10,
                                                   'older_than'     : '90d',
                                                   'name_regex'     : '.*',
                                                   'name_regex_keep': null,
                                                   'next_run_at'    : '2023-11-08T21:35:48.543+01:00'
                                               },
                                               'issues_enabled'                                  : true,
                                               'merge_requests_enabled'                          : true,
                                               'wiki_enabled'                                    : false,
                                               'jobs_enabled'                                    : true,
                                               'snippets_enabled'                                : true,
                                               'container_registry_enabled'                      : true,
                                               'service_desk_enabled'                            : false,
                                               'service_desk_address'                            : null,
                                               'can_create_merge_request_in'                     : true,
                                               'issues_access_level'                             : 'enabled',
                                               'repository_access_level'                         : 'enabled',
                                               'merge_requests_access_level'                     : 'enabled',
                                               'forking_access_level'                            : 'enabled',
                                               'wiki_access_level'                               : 'disabled',
                                               'builds_access_level'                             : 'enabled',
                                               'snippets_access_level'                           : 'enabled',
                                               'pages_access_level'                              : 'private',
                                               'analytics_access_level'                          : 'enabled',
                                               'container_registry_access_level'                 : 'enabled',
                                               'security_and_compliance_access_level'            : 'private',
                                               'releases_access_level'                           : 'enabled',
                                               'environments_access_level'                       : 'enabled',
                                               'feature_flags_access_level'                      : 'enabled',
                                               'infrastructure_access_level'                     : 'enabled',
                                               'monitor_access_level'                            : 'enabled',
                                               'emails_disabled'                                 : null,
                                               'shared_runners_enabled'                          : true,
                                               'lfs_enabled'                                     : true,
                                               'creator_id'                                      : 1076,
                                               'import_url'                                      : 'https://gitedu.hesge.ch/dojodev/template/empty_template.git',
                                               'import_type'                                     : 'git',
                                               'import_status'                                   : 'scheduled',
                                               'import_error'                                    : null,
                                               'open_issues_count'                               : 0,
                                               'description_html'                                : '<p data-sourcepos="1:1-1:27" dir="auto">Dojo assignment repository.</p>\n<p data-sourcepos="3:1-3:53" dir="auto">Name of the assignment: Technique de compilation - TP</p>',
                                               'updated_at'                                      : '2023-11-07T21:35:48.454+01:00',
                                               'ci_default_git_depth'                            : 20,
                                               'ci_forward_deployment_enabled'                   : true,
                                               'ci_job_token_scope_enabled'                      : false,
                                               'ci_separated_caches'                             : true,
                                               'ci_allow_fork_pipelines_to_run_in_parent_project': true,
                                               'build_git_strategy'                              : 'fetch',
                                               'keep_latest_artifact'                            : true,
                                               'restrict_user_defined_variables'                 : false,
                                               'runners_token'                                   : 'GR1348941qn9Ju1u5yTSLoWUTWLZy',
                                               'runner_token_expiration_interval'                : null,
                                               'group_runners_enabled'                           : true,
                                               'auto_cancel_pending_pipelines'                   : 'enabled',
                                               'build_timeout'                                   : 3600,
                                               'auto_devops_enabled'                             : false,
                                               'auto_devops_deploy_strategy'                     : 'continuous',
                                               'ci_config_path'                                  : '',
                                               'public_jobs'                                     : true,
                                               'shared_with_groups'                              : [],
                                               'only_allow_merge_if_pipeline_succeeds'           : false,
                                               'allow_merge_on_skipped_pipeline'                 : null,
                                               'request_access_enabled'                          : true,
                                               'only_allow_merge_if_all_discussions_are_resolved': false,
                                               'remove_source_branch_after_merge'                : true,
                                               'printing_merge_request_link_enabled'             : true,
                                               'merge_method'                                    : 'merge',
                                               'squash_option'                                   : 'default_off',
                                               'enforce_auth_checks_on_uploads'                  : true,
                                               'suggestion_commit_message'                       : null,
                                               'merge_commit_template'                           : null,
                                               'squash_commit_template'                          : null,
                                               'issue_branch_template'                           : null,
                                               'autoclose_referenced_issues'                     : true
                                           },
                                           gitlabLastInfo    : {
                                               'id'                                              : 13893,
                                               'description'                                     : 'Dojo assignment repository.\n\nName of the assignment: Technique de compilation - TP',
                                               'name'                                            : 'Technique de compilation - TP',
                                               'name_with_namespace'                             : 'DojoDev / Assignment / Technique de compilation - TP',
                                               'path'                                            : 'technique-de-compilation-tp',
                                               'path_with_namespace'                             : 'dojodev/assignment/technique-de-compilation-tp',
                                               'created_at'                                      : '2023-11-07T21:35:48.454+01:00',
                                               'default_branch'                                  : 'main',
                                               'tag_list'                                        : [],
                                               'topics'                                          : [],
                                               'ssh_url_to_repo'                                 : 'ssh://git@ssh.hesge.ch:10572/dojodev/assignment/technique-de-compilation-tp.git',
                                               'http_url_to_repo'                                : 'https://gitedu.hesge.ch/dojodev/assignment/technique-de-compilation-tp.git',
                                               'web_url'                                         : 'https://gitedu.hesge.ch/dojodev/assignment/technique-de-compilation-tp',
                                               'readme_url'                                      : null,
                                               'forks_count'                                     : 0,
                                               'avatar_url'                                      : null,
                                               'star_count'                                      : 0,
                                               'last_activity_at'                                : '2023-11-07T21:35:48.454+01:00',
                                               'namespace'                                       : {
                                                   'id'        : 14190,
                                                   'name'      : 'Assignment',
                                                   'path'      : 'assignment',
                                                   'kind'      : 'group',
                                                   'full_path' : 'dojodev/assignment',
                                                   'parent_id' : 14189,
                                                   'avatar_url': null,
                                                   'web_url'   : 'https://gitedu.hesge.ch/groups/dojodev/assignment'
                                               },
                                               '_links'                                          : {
                                                   'self'          : 'https://gitedu.hesge.ch/api/v4/projects/13893',
                                                   'issues'        : 'https://gitedu.hesge.ch/api/v4/projects/13893/issues',
                                                   'merge_requests': 'https://gitedu.hesge.ch/api/v4/projects/13893/merge_requests',
                                                   'repo_branches' : 'https://gitedu.hesge.ch/api/v4/projects/13893/repository/branches',
                                                   'labels'        : 'https://gitedu.hesge.ch/api/v4/projects/13893/labels',
                                                   'events'        : 'https://gitedu.hesge.ch/api/v4/projects/13893/events',
                                                   'members'       : 'https://gitedu.hesge.ch/api/v4/projects/13893/members',
                                                   'cluster_agents': 'https://gitedu.hesge.ch/api/v4/projects/13893/cluster_agents'
                                               },
                                               'packages_enabled'                                : true,
                                               'empty_repo'                                      : true,
                                               'archived'                                        : false,
                                               'visibility'                                      : 'private',
                                               'resolve_outdated_diff_discussions'               : false,
                                               'container_expiration_policy'                     : {
                                                   'cadence'        : '1d',
                                                   'enabled'        : false,
                                                   'keep_n'         : 10,
                                                   'older_than'     : '90d',
                                                   'name_regex'     : '.*',
                                                   'name_regex_keep': null,
                                                   'next_run_at'    : '2023-11-08T21:35:48.543+01:00'
                                               },
                                               'issues_enabled'                                  : true,
                                               'merge_requests_enabled'                          : true,
                                               'wiki_enabled'                                    : false,
                                               'jobs_enabled'                                    : true,
                                               'snippets_enabled'                                : true,
                                               'container_registry_enabled'                      : true,
                                               'service_desk_enabled'                            : false,
                                               'service_desk_address'                            : null,
                                               'can_create_merge_request_in'                     : true,
                                               'issues_access_level'                             : 'enabled',
                                               'repository_access_level'                         : 'enabled',
                                               'merge_requests_access_level'                     : 'enabled',
                                               'forking_access_level'                            : 'enabled',
                                               'wiki_access_level'                               : 'disabled',
                                               'builds_access_level'                             : 'enabled',
                                               'snippets_access_level'                           : 'enabled',
                                               'pages_access_level'                              : 'private',
                                               'analytics_access_level'                          : 'enabled',
                                               'container_registry_access_level'                 : 'enabled',
                                               'security_and_compliance_access_level'            : 'private',
                                               'releases_access_level'                           : 'enabled',
                                               'environments_access_level'                       : 'enabled',
                                               'feature_flags_access_level'                      : 'enabled',
                                               'infrastructure_access_level'                     : 'enabled',
                                               'monitor_access_level'                            : 'enabled',
                                               'emails_disabled'                                 : null,
                                               'shared_runners_enabled'                          : true,
                                               'lfs_enabled'                                     : true,
                                               'creator_id'                                      : 1076,
                                               'import_url'                                      : 'https://gitedu.hesge.ch/dojodev/template/empty_template.git',
                                               'import_type'                                     : 'git',
                                               'import_status'                                   : 'scheduled',
                                               'import_error'                                    : null,
                                               'open_issues_count'                               : 0,
                                               'description_html'                                : '<p data-sourcepos="1:1-1:27" dir="auto">Dojo assignment repository.</p>\n<p data-sourcepos="3:1-3:53" dir="auto">Name of the assignment: Technique de compilation - TP</p>',
                                               'updated_at'                                      : '2023-11-07T21:35:48.454+01:00',
                                               'ci_default_git_depth'                            : 20,
                                               'ci_forward_deployment_enabled'                   : true,
                                               'ci_job_token_scope_enabled'                      : false,
                                               'ci_separated_caches'                             : true,
                                               'ci_allow_fork_pipelines_to_run_in_parent_project': true,
                                               'build_git_strategy'                              : 'fetch',
                                               'keep_latest_artifact'                            : true,
                                               'restrict_user_defined_variables'                 : false,
                                               'runners_token'                                   : 'GR1348941qn9Ju1u5yTSLoWUTWLZy',
                                               'runner_token_expiration_interval'                : null,
                                               'group_runners_enabled'                           : true,
                                               'auto_cancel_pending_pipelines'                   : 'enabled',
                                               'build_timeout'                                   : 3600,
                                               'auto_devops_enabled'                             : false,
                                               'auto_devops_deploy_strategy'                     : 'continuous',
                                               'ci_config_path'                                  : '',
                                               'public_jobs'                                     : true,
                                               'shared_with_groups'                              : [],
                                               'only_allow_merge_if_pipeline_succeeds'           : false,
                                               'allow_merge_on_skipped_pipeline'                 : null,
                                               'request_access_enabled'                          : true,
                                               'only_allow_merge_if_all_discussions_are_resolved': false,
                                               'remove_source_branch_after_merge'                : true,
                                               'printing_merge_request_link_enabled'             : true,
                                               'merge_method'                                    : 'merge',
                                               'squash_option'                                   : 'default_off',
                                               'enforce_auth_checks_on_uploads'                  : true,
                                               'suggestion_commit_message'                       : null,
                                               'merge_commit_template'                           : null,
                                               'squash_commit_template'                          : null,
                                               'issue_branch_template'                           : null,
                                               'autoclose_referenced_issues'                     : true
                                           },
                                           gitlabLastInfoDate: new Date('2023-11-07T20:35:54.692Z'),
                                           published         : true
                                       }
                                   });
    }
}

async function exercises() {
    if ( !SharedConfig.production ) {
        await db.exercise.upsert({
                                     where : { id: 'dc7e1433-23f8-4c8a-a7f3-478b65fa9815' },
                                     update: {},
                                     create: {
                                         id                : 'dc7e1433-23f8-4c8a-a7f3-478b65fa9815',
                                         assignmentName    : 'Technique de compilation - TP',
                                         name              : 'DojoEx - Technique de compilation - TP - michael.minelli',
                                         gitlabId          : 14232,
                                         gitlabLink        : 'https://gitedu.hesge.ch/dojodev/exercise/dojo-ex_technique-de-compilation-tp_dc7e1433-23f8-4c8a-a7f3-478b65fa9815',
                                         gitlabCreationInfo: {
                                             'id'                                              : 14232,
                                             'description'                                     : 'Dojo exercise repository based on the the assignment: Technique de compilation - TP',
                                             'name'                                            : 'DojoEx - Technique de compilation - TP - michael.minelli',
                                             'name_with_namespace'                             : 'DojoDev / Exercise / DojoEx - Technique de compilation - TP - michael.minelli',
                                             'path'                                            : 'dojo-ex_technique-de-compilation-tp_dc7e1433-23f8-4c8a-a7f3-478b65fa9815',
                                             'path_with_namespace'                             : 'dojodev/exercise/dojo-ex_technique-de-compilation-tp_dc7e1433-23f8-4c8a-a7f3-478b65fa9815',
                                             'created_at'                                      : '2023-12-14T17:58:48.185+01:00',
                                             'default_branch'                                  : 'main',
                                             'tag_list'                                        : [],
                                             'topics'                                          : [],
                                             'ssh_url_to_repo'                                 : 'ssh://git@ssh.hesge.ch:10572/dojodev/exercise/dojo-ex_technique-de-compilation-tp_dc7e1433-23f8-4c8a-a7f3-478b65fa9815.git',
                                             'http_url_to_repo'                                : 'https://gitedu.hesge.ch/dojodev/exercise/dojo-ex_technique-de-compilation-tp_dc7e1433-23f8-4c8a-a7f3-478b65fa9815.git',
                                             'web_url'                                         : 'https://gitedu.hesge.ch/dojodev/exercise/dojo-ex_technique-de-compilation-tp_dc7e1433-23f8-4c8a-a7f3-478b65fa9815',
                                             'readme_url'                                      : null,
                                             'forks_count'                                     : 0,
                                             'avatar_url'                                      : null,
                                             'star_count'                                      : 0,
                                             'last_activity_at'                                : '2023-12-14T17:58:48.185+01:00',
                                             'namespace'                                       : {
                                                 'id'        : 14191,
                                                 'name'      : 'Exercise',
                                                 'path'      : 'exercise',
                                                 'kind'      : 'group',
                                                 'full_path' : 'dojodev/exercise',
                                                 'parent_id' : 14189,
                                                 'avatar_url': null,
                                                 'web_url'   : 'https://gitedu.hesge.ch/groups/dojodev/exercise'
                                             },
                                             '_links'                                          : {
                                                 'self'          : 'https://gitedu.hesge.ch/api/v4/projects/14232',
                                                 'issues'        : 'https://gitedu.hesge.ch/api/v4/projects/14232/issues',
                                                 'merge_requests': 'https://gitedu.hesge.ch/api/v4/projects/14232/merge_requests',
                                                 'repo_branches' : 'https://gitedu.hesge.ch/api/v4/projects/14232/repository/branches',
                                                 'labels'        : 'https://gitedu.hesge.ch/api/v4/projects/14232/labels',
                                                 'events'        : 'https://gitedu.hesge.ch/api/v4/projects/14232/events',
                                                 'members'       : 'https://gitedu.hesge.ch/api/v4/projects/14232/members',
                                                 'cluster_agents': 'https://gitedu.hesge.ch/api/v4/projects/14232/cluster_agents'
                                             },
                                             'packages_enabled'                                : true,
                                             'empty_repo'                                      : true,
                                             'archived'                                        : false,
                                             'visibility'                                      : 'private',
                                             'resolve_outdated_diff_discussions'               : false,
                                             'container_expiration_policy'                     : {
                                                 'cadence'        : '1d',
                                                 'enabled'        : false,
                                                 'keep_n'         : 10,
                                                 'older_than'     : '90d',
                                                 'name_regex'     : '.*',
                                                 'name_regex_keep': null,
                                                 'next_run_at'    : '2023-12-15T17:58:48.207+01:00'
                                             },
                                             'issues_enabled'                                  : true,
                                             'merge_requests_enabled'                          : true,
                                             'wiki_enabled'                                    : false,
                                             'jobs_enabled'                                    : true,
                                             'snippets_enabled'                                : true,
                                             'container_registry_enabled'                      : true,
                                             'service_desk_enabled'                            : false,
                                             'service_desk_address'                            : null,
                                             'can_create_merge_request_in'                     : true,
                                             'issues_access_level'                             : 'enabled',
                                             'repository_access_level'                         : 'enabled',
                                             'merge_requests_access_level'                     : 'enabled',
                                             'forking_access_level'                            : 'enabled',
                                             'wiki_access_level'                               : 'disabled',
                                             'builds_access_level'                             : 'enabled',
                                             'snippets_access_level'                           : 'enabled',
                                             'pages_access_level'                              : 'private',
                                             'analytics_access_level'                          : 'enabled',
                                             'container_registry_access_level'                 : 'enabled',
                                             'security_and_compliance_access_level'            : 'private',
                                             'releases_access_level'                           : 'enabled',
                                             'environments_access_level'                       : 'enabled',
                                             'feature_flags_access_level'                      : 'enabled',
                                             'infrastructure_access_level'                     : 'enabled',
                                             'monitor_access_level'                            : 'enabled',
                                             'emails_disabled'                                 : null,
                                             'shared_runners_enabled'                          : true,
                                             'lfs_enabled'                                     : true,
                                             'creator_id'                                      : 1076,
                                             'forked_from_project'                             : {
                                                 'id'                 : 13893,
                                                 'description'        : 'Dojo assignment repository.\n\nName of the assignment: Technique de compilation - TP',
                                                 'name'               : 'Technique de compilation - TP',
                                                 'name_with_namespace': 'DojoDev / Assignment / Technique de compilation - TP',
                                                 'path'               : 'technique-de-compilation-tp',
                                                 'path_with_namespace': 'dojodev/assignment/technique-de-compilation-tp',
                                                 'created_at'         : '2023-11-07T21:35:48.454+01:00',
                                                 'default_branch'     : 'main',
                                                 'tag_list'           : [],
                                                 'topics'             : [],
                                                 'ssh_url_to_repo'    : 'ssh://git@ssh.hesge.ch:10572/dojodev/assignment/technique-de-compilation-tp.git',
                                                 'http_url_to_repo'   : 'https://gitedu.hesge.ch/dojodev/assignment/technique-de-compilation-tp.git',
                                                 'web_url'            : 'https://gitedu.hesge.ch/dojodev/assignment/technique-de-compilation-tp',
                                                 'readme_url'         : 'https://gitedu.hesge.ch/dojodev/assignment/technique-de-compilation-tp/-/blob/main/README.md',
                                                 'forks_count'        : 1,
                                                 'avatar_url'         : null,
                                                 'star_count'         : 0,
                                                 'last_activity_at'   : '2023-11-14T13:14:13.820+01:00',
                                                 'namespace'          : {
                                                     'id'        : 14190,
                                                     'name'      : 'Assignment',
                                                     'path'      : 'assignment',
                                                     'kind'      : 'group',
                                                     'full_path' : 'dojodev/assignment',
                                                     'parent_id' : 14189,
                                                     'avatar_url': null,
                                                     'web_url'   : 'https://gitedu.hesge.ch/groups/dojodev/assignment'
                                                 }
                                             },
                                             'mr_default_target_self'                          : false,
                                             'import_url'                                      : null,
                                             'import_type'                                     : null,
                                             'import_status'                                   : 'scheduled',
                                             'import_error'                                    : null,
                                             'open_issues_count'                               : 0,
                                             'description_html'                                : '<p data-sourcepos="1:1-1:83" dir="auto">Dojo exercise repository based on the the assignment: Technique de compilation - TP</p>',
                                             'updated_at'                                      : '2023-12-14T17:58:48.185+01:00',
                                             'ci_default_git_depth'                            : 20,
                                             'ci_forward_deployment_enabled'                   : true,
                                             'ci_job_token_scope_enabled'                      : false,
                                             'ci_separated_caches'                             : true,
                                             'ci_allow_fork_pipelines_to_run_in_parent_project': true,
                                             'build_git_strategy'                              : 'fetch',
                                             'keep_latest_artifact'                            : true,
                                             'restrict_user_defined_variables'                 : false,
                                             'runners_token'                                   : 'GR1348941tdWz3ZxaqbRBmjL5A6r2',
                                             'runner_token_expiration_interval'                : null,
                                             'group_runners_enabled'                           : true,
                                             'auto_cancel_pending_pipelines'                   : 'enabled',
                                             'build_timeout'                                   : 3600,
                                             'auto_devops_enabled'                             : false,
                                             'auto_devops_deploy_strategy'                     : 'continuous',
                                             'ci_config_path'                                  : '',
                                             'public_jobs'                                     : true,
                                             'shared_with_groups'                              : [],
                                             'only_allow_merge_if_pipeline_succeeds'           : false,
                                             'allow_merge_on_skipped_pipeline'                 : null,
                                             'request_access_enabled'                          : true,
                                             'only_allow_merge_if_all_discussions_are_resolved': false,
                                             'remove_source_branch_after_merge'                : true,
                                             'printing_merge_request_link_enabled'             : true,
                                             'merge_method'                                    : 'merge',
                                             'squash_option'                                   : 'default_off',
                                             'enforce_auth_checks_on_uploads'                  : true,
                                             'suggestion_commit_message'                       : null,
                                             'merge_commit_template'                           : null,
                                             'squash_commit_template'                          : null,
                                             'issue_branch_template'                           : null,
                                             'autoclose_referenced_issues'                     : true
                                         },
                                         gitlabLastInfo    : {
                                             'id'                                              : 14232,
                                             'description'                                     : 'Dojo exercise repository based on the the assignment: Technique de compilation - TP',
                                             'name'                                            : 'DojoEx - Technique de compilation - TP - michael.minelli',
                                             'name_with_namespace'                             : 'DojoDev / Exercise / DojoEx - Technique de compilation - TP - michael.minelli',
                                             'path'                                            : 'dojo-ex_technique-de-compilation-tp_dc7e1433-23f8-4c8a-a7f3-478b65fa9815',
                                             'path_with_namespace'                             : 'dojodev/exercise/dojo-ex_technique-de-compilation-tp_dc7e1433-23f8-4c8a-a7f3-478b65fa9815',
                                             'created_at'                                      : '2023-12-14T17:58:48.185+01:00',
                                             'default_branch'                                  : 'main',
                                             'tag_list'                                        : [],
                                             'topics'                                          : [],
                                             'ssh_url_to_repo'                                 : 'ssh://git@ssh.hesge.ch:10572/dojodev/exercise/dojo-ex_technique-de-compilation-tp_dc7e1433-23f8-4c8a-a7f3-478b65fa9815.git',
                                             'http_url_to_repo'                                : 'https://gitedu.hesge.ch/dojodev/exercise/dojo-ex_technique-de-compilation-tp_dc7e1433-23f8-4c8a-a7f3-478b65fa9815.git',
                                             'web_url'                                         : 'https://gitedu.hesge.ch/dojodev/exercise/dojo-ex_technique-de-compilation-tp_dc7e1433-23f8-4c8a-a7f3-478b65fa9815',
                                             'readme_url'                                      : null,
                                             'forks_count'                                     : 0,
                                             'avatar_url'                                      : null,
                                             'star_count'                                      : 0,
                                             'last_activity_at'                                : '2023-12-14T17:58:48.185+01:00',
                                             'namespace'                                       : {
                                                 'id'        : 14191,
                                                 'name'      : 'Exercise',
                                                 'path'      : 'exercise',
                                                 'kind'      : 'group',
                                                 'full_path' : 'dojodev/exercise',
                                                 'parent_id' : 14189,
                                                 'avatar_url': null,
                                                 'web_url'   : 'https://gitedu.hesge.ch/groups/dojodev/exercise'
                                             },
                                             '_links'                                          : {
                                                 'self'          : 'https://gitedu.hesge.ch/api/v4/projects/14232',
                                                 'issues'        : 'https://gitedu.hesge.ch/api/v4/projects/14232/issues',
                                                 'merge_requests': 'https://gitedu.hesge.ch/api/v4/projects/14232/merge_requests',
                                                 'repo_branches' : 'https://gitedu.hesge.ch/api/v4/projects/14232/repository/branches',
                                                 'labels'        : 'https://gitedu.hesge.ch/api/v4/projects/14232/labels',
                                                 'events'        : 'https://gitedu.hesge.ch/api/v4/projects/14232/events',
                                                 'members'       : 'https://gitedu.hesge.ch/api/v4/projects/14232/members',
                                                 'cluster_agents': 'https://gitedu.hesge.ch/api/v4/projects/14232/cluster_agents'
                                             },
                                             'packages_enabled'                                : true,
                                             'empty_repo'                                      : true,
                                             'archived'                                        : false,
                                             'visibility'                                      : 'private',
                                             'resolve_outdated_diff_discussions'               : false,
                                             'container_expiration_policy'                     : {
                                                 'cadence'        : '1d',
                                                 'enabled'        : false,
                                                 'keep_n'         : 10,
                                                 'older_than'     : '90d',
                                                 'name_regex'     : '.*',
                                                 'name_regex_keep': null,
                                                 'next_run_at'    : '2023-12-15T17:58:48.207+01:00'
                                             },
                                             'issues_enabled'                                  : true,
                                             'merge_requests_enabled'                          : true,
                                             'wiki_enabled'                                    : false,
                                             'jobs_enabled'                                    : true,
                                             'snippets_enabled'                                : true,
                                             'container_registry_enabled'                      : true,
                                             'service_desk_enabled'                            : false,
                                             'service_desk_address'                            : null,
                                             'can_create_merge_request_in'                     : true,
                                             'issues_access_level'                             : 'enabled',
                                             'repository_access_level'                         : 'enabled',
                                             'merge_requests_access_level'                     : 'enabled',
                                             'forking_access_level'                            : 'enabled',
                                             'wiki_access_level'                               : 'disabled',
                                             'builds_access_level'                             : 'enabled',
                                             'snippets_access_level'                           : 'enabled',
                                             'pages_access_level'                              : 'private',
                                             'analytics_access_level'                          : 'enabled',
                                             'container_registry_access_level'                 : 'enabled',
                                             'security_and_compliance_access_level'            : 'private',
                                             'releases_access_level'                           : 'enabled',
                                             'environments_access_level'                       : 'enabled',
                                             'feature_flags_access_level'                      : 'enabled',
                                             'infrastructure_access_level'                     : 'enabled',
                                             'monitor_access_level'                            : 'enabled',
                                             'emails_disabled'                                 : null,
                                             'shared_runners_enabled'                          : true,
                                             'lfs_enabled'                                     : true,
                                             'creator_id'                                      : 1076,
                                             'forked_from_project'                             : {
                                                 'id'                 : 13893,
                                                 'description'        : 'Dojo assignment repository.\n\nName of the assignment: Technique de compilation - TP',
                                                 'name'               : 'Technique de compilation - TP',
                                                 'name_with_namespace': 'DojoDev / Assignment / Technique de compilation - TP',
                                                 'path'               : 'technique-de-compilation-tp',
                                                 'path_with_namespace': 'dojodev/assignment/technique-de-compilation-tp',
                                                 'created_at'         : '2023-11-07T21:35:48.454+01:00',
                                                 'default_branch'     : 'main',
                                                 'tag_list'           : [],
                                                 'topics'             : [],
                                                 'ssh_url_to_repo'    : 'ssh://git@ssh.hesge.ch:10572/dojodev/assignment/technique-de-compilation-tp.git',
                                                 'http_url_to_repo'   : 'https://gitedu.hesge.ch/dojodev/assignment/technique-de-compilation-tp.git',
                                                 'web_url'            : 'https://gitedu.hesge.ch/dojodev/assignment/technique-de-compilation-tp',
                                                 'readme_url'         : 'https://gitedu.hesge.ch/dojodev/assignment/technique-de-compilation-tp/-/blob/main/README.md',
                                                 'forks_count'        : 1,
                                                 'avatar_url'         : null,
                                                 'star_count'         : 0,
                                                 'last_activity_at'   : '2023-11-14T13:14:13.820+01:00',
                                                 'namespace'          : {
                                                     'id'        : 14190,
                                                     'name'      : 'Assignment',
                                                     'path'      : 'assignment',
                                                     'kind'      : 'group',
                                                     'full_path' : 'dojodev/assignment',
                                                     'parent_id' : 14189,
                                                     'avatar_url': null,
                                                     'web_url'   : 'https://gitedu.hesge.ch/groups/dojodev/assignment'
                                                 }
                                             },
                                             'mr_default_target_self'                          : false,
                                             'import_url'                                      : null,
                                             'import_type'                                     : null,
                                             'import_status'                                   : 'scheduled',
                                             'import_error'                                    : null,
                                             'open_issues_count'                               : 0,
                                             'description_html'                                : '<p data-sourcepos="1:1-1:83" dir="auto">Dojo exercise repository based on the the assignment: Technique de compilation - TP</p>',
                                             'updated_at'                                      : '2023-12-14T17:58:48.185+01:00',
                                             'ci_default_git_depth'                            : 20,
                                             'ci_forward_deployment_enabled'                   : true,
                                             'ci_job_token_scope_enabled'                      : false,
                                             'ci_separated_caches'                             : true,
                                             'ci_allow_fork_pipelines_to_run_in_parent_project': true,
                                             'build_git_strategy'                              : 'fetch',
                                             'keep_latest_artifact'                            : true,
                                             'restrict_user_defined_variables'                 : false,
                                             'runners_token'                                   : 'GR1348941tdWz3ZxaqbRBmjL5A6r2',
                                             'runner_token_expiration_interval'                : null,
                                             'group_runners_enabled'                           : true,
                                             'auto_cancel_pending_pipelines'                   : 'enabled',
                                             'build_timeout'                                   : 3600,
                                             'auto_devops_enabled'                             : false,
                                             'auto_devops_deploy_strategy'                     : 'continuous',
                                             'ci_config_path'                                  : '',
                                             'public_jobs'                                     : true,
                                             'shared_with_groups'                              : [],
                                             'only_allow_merge_if_pipeline_succeeds'           : false,
                                             'allow_merge_on_skipped_pipeline'                 : null,
                                             'request_access_enabled'                          : true,
                                             'only_allow_merge_if_all_discussions_are_resolved': false,
                                             'remove_source_branch_after_merge'                : true,
                                             'printing_merge_request_link_enabled'             : true,
                                             'merge_method'                                    : 'merge',
                                             'squash_option'                                   : 'default_off',
                                             'enforce_auth_checks_on_uploads'                  : true,
                                             'suggestion_commit_message'                       : null,
                                             'merge_commit_template'                           : null,
                                             'squash_commit_template'                          : null,
                                             'issue_branch_template'                           : null,
                                             'autoclose_referenced_issues'                     : true
                                         },
                                         gitlabLastInfoDate: new Date('2023-12-14T14:54:35.692Z'),
                                         secret            : 'ea01568d-2b84-49b7-8603-7d58346f21c6'
                                     }
                                 });
    }
}

async function results() {
    if ( !SharedConfig.production ) {
        await db.result.upsert({
                                   where : {
                                       exerciseId_dateTime: {
                                           exerciseId: 'dc7e1433-23f8-4c8a-a7f3-478b65fa9815',
                                           dateTime  : new Date('2023-12-14T14:55:35.692Z')
                                       }
                                   },
                                   update: {},
                                   create: {
                                       exerciseId: 'dc7e1433-23f8-4c8a-a7f3-478b65fa9815',
                                       dateTime  : new Date('2023-12-14T14:55:35.692Z'),
                                       commit    : {
                                           'shortSha'    : '0444bfb5',
                                           'description' : '',
                                           'refName'     : 'main',
                                           'refProtected': 'true',
                                           'sha'         : '0444bfb5e986a15b9dadd96c06a6e08b92d230b4',
                                           'timestamp'   : '2023-12-08T13:57:37+01:00',
                                           'title'       : 'Add .gitlab-ci.yml (DO NOT MODIFY THIS FILE)',
                                           'author'      : 'Dojo <hepia.dojo@protonmail.com>',
                                           'branch'      : 'main',
                                           'refSlug'     : 'main',
                                           'beforeSha'   : '2a48bd3c2cc2f810bf10d2b948acab9229253068',
                                           'message'     : 'Add .gitlab-ci.yml (DO NOT MODIFY THIS FILE)'
                                       },
                                       exitCode  : 1,
                                       files     : [ {
                                           'mode'     : 33188,
                                           'size'     : 10546,
                                           'mtime'    : '2023-12-08T12:58:31.109Z',
                                           'birthtime': '2023-12-08T12:58:31.109Z',
                                           'ext'      : 'txt',
                                           'name'     : 'dockerComposeLogs.txt',
                                           'path'     : 'Dojo/dockerComposeLogs.txt'
                                       }, {
                                           'mode'     : 33188,
                                           'size'     : 493,
                                           'mtime'    : '2023-12-08T12:58:31.562Z',
                                           'birthtime': '2023-12-08T12:58:31.562Z',
                                           'ext'      : 'json',
                                           'name'     : 'results.json',
                                           'path'     : 'Dojo/results.json'
                                       }, {
                                           'mode'     : 33188,
                                           'size'     : 5593,
                                           'mtime'    : '2023-12-08T12:58:30.891Z',
                                           'birthtime': '2023-12-08T12:58:30.891Z',
                                           'ext'      : 'txt',
                                           'name'     : 'detailedResults.txt',
                                           'path'     : 'Exercise/detailedResults.txt'
                                       }, {
                                           'mode'     : 33188,
                                           'size'     : 149,
                                           'mtime'    : '2023-12-08T12:58:25.855Z',
                                           'birthtime': '2023-12-08T12:58:30.892Z',
                                           'ext'      : 'bytecode',
                                           'name'     : 'test_1.bytecode',
                                           'path'     : 'Exercise/TestsResults/test_1.bytecode'
                                       }, {
                                           'mode'     : 33188,
                                           'size'     : 1,
                                           'mtime'    : '2023-12-08T12:58:25.983Z',
                                           'birthtime': '2023-12-08T12:58:30.892Z',
                                           'ext'      : 'output',
                                           'name'     : 'test_1.output',
                                           'path'     : 'Exercise/TestsResults/test_1.output'
                                       }, {
                                           'mode'     : 33188,
                                           'size'     : 468,
                                           'mtime'    : '2023-12-08T12:58:25.702Z',
                                           'birthtime': '2023-12-08T12:58:30.892Z',
                                           'ext'      : 'source',
                                           'name'     : 'test_1.source',
                                           'path'     : 'Exercise/TestsResults/test_1.source'
                                       }, {
                                           'mode'     : 33188,
                                           'size'     : 149,
                                           'mtime'    : '2023-12-08T12:58:30.247Z',
                                           'birthtime': '2023-12-08T12:58:30.894Z',
                                           'ext'      : 'bytecode',
                                           'name'     : 'test_10.bytecode',
                                           'path'     : 'Exercise/TestsResults/test_10.bytecode'
                                       }, {
                                           'mode'     : 33188,
                                           'size'     : 1,
                                           'mtime'    : '2023-12-08T12:58:30.376Z',
                                           'birthtime': '2023-12-08T12:58:30.894Z',
                                           'ext'      : 'output',
                                           'name'     : 'test_10.output',
                                           'path'     : 'Exercise/TestsResults/test_10.output'
                                       }, {
                                           'mode'     : 33188,
                                           'size'     : 468,
                                           'mtime'    : '2023-12-08T12:58:30.098Z',
                                           'birthtime': '2023-12-08T12:58:30.894Z',
                                           'ext'      : 'source',
                                           'name'     : 'test_10.source',
                                           'path'     : 'Exercise/TestsResults/test_10.source'
                                       }, {
                                           'mode'     : 33188,
                                           'size'     : 149,
                                           'mtime'    : '2023-12-08T12:58:30.737Z',
                                           'birthtime': '2023-12-08T12:58:30.894Z',
                                           'ext'      : 'bytecode',
                                           'name'     : 'test_11.bytecode',
                                           'path'     : 'Exercise/TestsResults/test_11.bytecode'
                                       }, {
                                           'mode'     : 33188,
                                           'size'     : 468,
                                           'mtime'    : '2023-12-08T12:58:30.584Z',
                                           'birthtime': '2023-12-08T12:58:30.894Z',
                                           'ext'      : 'source',
                                           'name'     : 'test_11.source',
                                           'path'     : 'Exercise/TestsResults/test_11.source'
                                       }, {
                                           'mode'     : 33188,
                                           'size'     : 1,
                                           'mtime'    : '2023-12-08T12:58:30.890Z',
                                           'birthtime': '2023-12-08T12:58:30.894Z',
                                           'ext'      : 'output',
                                           'name'     : 'test_11.output',
                                           'path'     : 'Exercise/TestsResults/test_11.output'
                                       }, {
                                           'mode'     : 33188,
                                           'size'     : 149,
                                           'mtime'    : '2023-12-08T12:58:26.322Z',
                                           'birthtime': '2023-12-08T12:58:30.892Z',
                                           'ext'      : 'bytecode',
                                           'name'     : 'test_2.bytecode',
                                           'path'     : 'Exercise/TestsResults/test_2.bytecode'
                                       }, {
                                           'mode'     : 33188,
                                           'size'     : 1,
                                           'mtime'    : '2023-12-08T12:58:26.455Z',
                                           'birthtime': '2023-12-08T12:58:30.892Z',
                                           'ext'      : 'output',
                                           'name'     : 'test_2.output',
                                           'path'     : 'Exercise/TestsResults/test_2.output'
                                       }, {
                                           'mode'     : 33188,
                                           'size'     : 639,
                                           'mtime'    : '2023-12-08T12:58:26.178Z',
                                           'birthtime': '2023-12-08T12:58:30.892Z',
                                           'ext'      : 'source',
                                           'name'     : 'test_2.source',
                                           'path'     : 'Exercise/TestsResults/test_2.source'
                                       }, {
                                           'mode'     : 33188,
                                           'size'     : 149,
                                           'mtime'    : '2023-12-08T12:58:26.781Z',
                                           'birthtime': '2023-12-08T12:58:30.892Z',
                                           'ext'      : 'bytecode',
                                           'name'     : 'test_3.bytecode',
                                           'path'     : 'Exercise/TestsResults/test_3.bytecode'
                                       }, {
                                           'mode'     : 33188,
                                           'size'     : 1,
                                           'mtime'    : '2023-12-08T12:58:26.884Z',
                                           'birthtime': '2023-12-08T12:58:30.892Z',
                                           'ext'      : 'output',
                                           'name'     : 'test_3.output',
                                           'path'     : 'Exercise/TestsResults/test_3.output'
                                       }, {
                                           'mode'     : 33188,
                                           'size'     : 468,
                                           'mtime'    : '2023-12-08T12:58:26.637Z',
                                           'birthtime': '2023-12-08T12:58:30.892Z',
                                           'ext'      : 'source',
                                           'name'     : 'test_3.source',
                                           'path'     : 'Exercise/TestsResults/test_3.source'
                                       }, {
                                           'mode'     : 33188,
                                           'size'     : 149,
                                           'mtime'    : '2023-12-08T12:58:27.228Z',
                                           'birthtime': '2023-12-08T12:58:30.893Z',
                                           'ext'      : 'bytecode',
                                           'name'     : 'test_4.bytecode',
                                           'path'     : 'Exercise/TestsResults/test_4.bytecode'
                                       }, {
                                           'mode'     : 33188,
                                           'size'     : 1,
                                           'mtime'    : '2023-12-08T12:58:27.331Z',
                                           'birthtime': '2023-12-08T12:58:30.893Z',
                                           'ext'      : 'output',
                                           'name'     : 'test_4.output',
                                           'path'     : 'Exercise/TestsResults/test_4.output'
                                       }, {
                                           'mode'     : 33188,
                                           'size'     : 468,
                                           'mtime'    : '2023-12-08T12:58:27.092Z',
                                           'birthtime': '2023-12-08T12:58:30.893Z',
                                           'ext'      : 'source',
                                           'name'     : 'test_4.source',
                                           'path'     : 'Exercise/TestsResults/test_4.source'
                                       }, {
                                           'mode'     : 33188,
                                           'size'     : 149,
                                           'mtime'    : '2023-12-08T12:58:27.688Z',
                                           'birthtime': '2023-12-08T12:58:30.893Z',
                                           'ext'      : 'bytecode',
                                           'name'     : 'test_5.bytecode',
                                           'path'     : 'Exercise/TestsResults/test_5.bytecode'
                                       }, {
                                           'mode'     : 33188,
                                           'size'     : 1,
                                           'mtime'    : '2023-12-08T12:58:27.820Z',
                                           'birthtime': '2023-12-08T12:58:30.893Z',
                                           'ext'      : 'output',
                                           'name'     : 'test_5.output',
                                           'path'     : 'Exercise/TestsResults/test_5.output'
                                       }, {
                                           'mode'     : 33188,
                                           'size'     : 639,
                                           'mtime'    : '2023-12-08T12:58:27.533Z',
                                           'birthtime': '2023-12-08T12:58:30.893Z',
                                           'ext'      : 'source',
                                           'name'     : 'test_5.source',
                                           'path'     : 'Exercise/TestsResults/test_5.source'
                                       }, {
                                           'mode'     : 33188,
                                           'size'     : 149,
                                           'mtime'    : '2023-12-08T12:58:28.177Z',
                                           'birthtime': '2023-12-08T12:58:30.893Z',
                                           'ext'      : 'bytecode',
                                           'name'     : 'test_6.bytecode',
                                           'path'     : 'Exercise/TestsResults/test_6.bytecode'
                                       }, {
                                           'mode'     : 33188,
                                           'size'     : 1,
                                           'mtime'    : '2023-12-08T12:58:28.322Z',
                                           'birthtime': '2023-12-08T12:58:30.893Z',
                                           'ext'      : 'output',
                                           'name'     : 'test_6.output',
                                           'path'     : 'Exercise/TestsResults/test_6.output'
                                       }, {
                                           'mode'     : 33188,
                                           'size'     : 639,
                                           'mtime'    : '2023-12-08T12:58:28.033Z',
                                           'birthtime': '2023-12-08T12:58:30.893Z',
                                           'ext'      : 'source',
                                           'name'     : 'test_6.source',
                                           'path'     : 'Exercise/TestsResults/test_6.source'
                                       }, {
                                           'mode'     : 33188,
                                           'size'     : 149,
                                           'mtime'    : '2023-12-08T12:58:28.696Z',
                                           'birthtime': '2023-12-08T12:58:30.893Z',
                                           'ext'      : 'bytecode',
                                           'name'     : 'test_7.bytecode',
                                           'path'     : 'Exercise/TestsResults/test_7.bytecode'
                                       }, {
                                           'mode'     : 33188,
                                           'size'     : 1,
                                           'mtime'    : '2023-12-08T12:58:28.871Z',
                                           'birthtime': '2023-12-08T12:58:30.893Z',
                                           'ext'      : 'output',
                                           'name'     : 'test_7.output',
                                           'path'     : 'Exercise/TestsResults/test_7.output'
                                       }, {
                                           'mode'     : 33188,
                                           'size'     : 468,
                                           'mtime'    : '2023-12-08T12:58:28.538Z',
                                           'birthtime': '2023-12-08T12:58:30.893Z',
                                           'ext'      : 'source',
                                           'name'     : 'test_7.source',
                                           'path'     : 'Exercise/TestsResults/test_7.source'
                                       }, {
                                           'mode'     : 33188,
                                           'size'     : 149,
                                           'mtime'    : '2023-12-08T12:58:29.229Z',
                                           'birthtime': '2023-12-08T12:58:30.893Z',
                                           'ext'      : 'bytecode',
                                           'name'     : 'test_8.bytecode',
                                           'path'     : 'Exercise/TestsResults/test_8.bytecode'
                                       }, {
                                           'mode'     : 33188,
                                           'size'     : 1,
                                           'mtime'    : '2023-12-08T12:58:29.352Z',
                                           'birthtime': '2023-12-08T12:58:30.893Z',
                                           'ext'      : 'output',
                                           'name'     : 'test_8.output',
                                           'path'     : 'Exercise/TestsResults/test_8.output'
                                       }, {
                                           'mode'     : 33188,
                                           'size'     : 468,
                                           'mtime'    : '2023-12-08T12:58:29.087Z',
                                           'birthtime': '2023-12-08T12:58:30.893Z',
                                           'ext'      : 'source',
                                           'name'     : 'test_8.source',
                                           'path'     : 'Exercise/TestsResults/test_8.source'
                                       }, {
                                           'mode'     : 33188,
                                           'size'     : 149,
                                           'mtime'    : '2023-12-08T12:58:29.723Z',
                                           'birthtime': '2023-12-08T12:58:30.894Z',
                                           'ext'      : 'bytecode',
                                           'name'     : 'test_9.bytecode',
                                           'path'     : 'Exercise/TestsResults/test_9.bytecode'
                                       }, {
                                           'mode'     : 33188,
                                           'size'     : 1,
                                           'mtime'    : '2023-12-08T12:58:29.886Z',
                                           'birthtime': '2023-12-08T12:58:30.894Z',
                                           'ext'      : 'output',
                                           'name'     : 'test_9.output',
                                           'path'     : 'Exercise/TestsResults/test_9.output'
                                       }, {
                                           'mode'     : 33188,
                                           'size'     : 468,
                                           'mtime'    : '2023-12-08T12:58:29.570Z',
                                           'birthtime': '2023-12-08T12:58:30.894Z',
                                           'ext'      : 'source',
                                           'name'     : 'test_9.source',
                                           'path'     : 'Exercise/TestsResults/test_9.source'
                                       } ],
                                       results   : {
                                           'successfulTests'    : 0,
                                           'failedTests'        : 16,
                                           'successfulTestsList': [],
                                           'failedTestsList'    : [ 'Test 1', 'Test 2', 'Test 3', 'Test 4', 'Test 5', 'Test 6', 'Test 7', 'Test 8', 'Test 9', 'Test 10', 'Test 11', 'Semantic error 1', 'Semantic error 2', 'Semantic error 3', 'Semantic error 4', 'Semantic error 5' ],
                                           'success'            : false,
                                           'containerExitCode'  : 1
                                       },
                                       success   : false
                                   }
                               });

        await db.result.upsert({
                                   where : {
                                       exerciseId_dateTime: {
                                           exerciseId: 'dc7e1433-23f8-4c8a-a7f3-478b65fa9815',
                                           dateTime  : new Date('2023-12-14T15:35:35.692Z')
                                       }
                                   },
                                   update: {},
                                   create: {
                                       exerciseId: 'dc7e1433-23f8-4c8a-a7f3-478b65fa9815',
                                       dateTime  : new Date('2023-12-14T15:35:35.692Z'),
                                       commit    : {
                                           'shortSha'    : 'bacb58a8',
                                           'description' : '',
                                           'refName'     : 'main',
                                           'refProtected': 'true',
                                           'sha'         : 'bacb58a801f93ab9eb08a4a5949a498588c656ff',
                                           'timestamp'   : '2023-12-08T14:05:39+01:00',
                                           'title'       : 'Commit final',
                                           'author'      : 'Michaël Minelli <michael@minelli.me>',
                                           'branch'      : 'main',
                                           'refSlug'     : 'main',
                                           'beforeSha'   : '0444bfb5e986a15b9dadd96c06a6e08b92d230b4',
                                           'message'     : 'Commit final\n'
                                       },
                                       exitCode  : 0,
                                       files     : [ {
                                           'mode'     : 33188,
                                           'size'     : 10256,
                                           'mtime'    : '2023-12-08T13:06:36.546Z',
                                           'birthtime': '2023-12-08T13:06:36.546Z',
                                           'ext'      : 'txt',
                                           'name'     : 'dockerComposeLogs.txt',
                                           'path'     : 'Dojo/dockerComposeLogs.txt'
                                       }, {
                                           'mode'     : 33188,
                                           'size'     : 492,
                                           'mtime'    : '2023-12-08T13:06:36.960Z',
                                           'birthtime': '2023-12-08T13:06:36.960Z',
                                           'ext'      : 'json',
                                           'name'     : 'results.json',
                                           'path'     : 'Dojo/results.json'
                                       }, {
                                           'mode'     : 33188,
                                           'size'     : 852,
                                           'mtime'    : '2023-12-08T13:06:36.336Z',
                                           'birthtime': '2023-12-08T13:06:36.336Z',
                                           'ext'      : 'txt',
                                           'name'     : 'detailedResults.txt',
                                           'path'     : 'Exercise/detailedResults.txt'
                                       }, {
                                           'mode'     : 33188,
                                           'size'     : 783,
                                           'mtime'    : '2023-12-08T13:06:30.478Z',
                                           'birthtime': '2023-12-08T13:06:36.337Z',
                                           'ext'      : 'bytecode',
                                           'name'     : 'test_1.bytecode',
                                           'path'     : 'Exercise/TestsResults/test_1.bytecode'
                                       }, {
                                           'mode'     : 33188,
                                           'size'     : 31,
                                           'mtime'    : '2023-12-08T13:06:30.591Z',
                                           'birthtime': '2023-12-08T13:06:36.337Z',
                                           'ext'      : 'output',
                                           'name'     : 'test_1.output',
                                           'path'     : 'Exercise/TestsResults/test_1.output'
                                       }, {
                                           'mode'     : 33188,
                                           'size'     : 115,
                                           'mtime'    : '2023-12-08T13:06:30.274Z',
                                           'birthtime': '2023-12-08T13:06:36.337Z',
                                           'ext'      : 'source',
                                           'name'     : 'test_1.source',
                                           'path'     : 'Exercise/TestsResults/test_1.source'
                                       }, {
                                           'mode'     : 33188,
                                           'size'     : 919,
                                           'mtime'    : '2023-12-08T13:06:35.694Z',
                                           'birthtime': '2023-12-08T13:06:36.341Z',
                                           'ext'      : 'bytecode',
                                           'name'     : 'test_10.bytecode',
                                           'path'     : 'Exercise/TestsResults/test_10.bytecode'
                                       }, {
                                           'mode'     : 33188,
                                           'size'     : 45,
                                           'mtime'    : '2023-12-08T13:06:35.812Z',
                                           'birthtime': '2023-12-08T13:06:36.341Z',
                                           'ext'      : 'output',
                                           'name'     : 'test_10.output',
                                           'path'     : 'Exercise/TestsResults/test_10.output'
                                       }, {
                                           'mode'     : 33188,
                                           'size'     : 147,
                                           'mtime'    : '2023-12-08T13:06:35.509Z',
                                           'birthtime': '2023-12-08T13:06:36.341Z',
                                           'ext'      : 'source',
                                           'name'     : 'test_10.source',
                                           'path'     : 'Exercise/TestsResults/test_10.source'
                                       }, {
                                           'mode'     : 33188,
                                           'size'     : 517,
                                           'mtime'    : '2023-12-08T13:06:36.221Z',
                                           'birthtime': '2023-12-08T13:06:36.341Z',
                                           'ext'      : 'bytecode',
                                           'name'     : 'test_11.bytecode',
                                           'path'     : 'Exercise/TestsResults/test_11.bytecode'
                                       }, {
                                           'mode'     : 33188,
                                           'size'     : 8,
                                           'mtime'    : '2023-12-08T13:06:36.333Z',
                                           'birthtime': '2023-12-08T13:06:36.341Z',
                                           'ext'      : 'output',
                                           'name'     : 'test_11.output',
                                           'path'     : 'Exercise/TestsResults/test_11.output'
                                       }, {
                                           'mode'     : 33188,
                                           'size'     : 121,
                                           'mtime'    : '2023-12-08T13:06:36.041Z',
                                           'birthtime': '2023-12-08T13:06:36.341Z',
                                           'ext'      : 'source',
                                           'name'     : 'test_11.source',
                                           'path'     : 'Exercise/TestsResults/test_11.source'
                                       }, {
                                           'mode'     : 33188,
                                           'size'     : 915,
                                           'mtime'    : '2023-12-08T13:06:31.011Z',
                                           'birthtime': '2023-12-08T13:06:36.338Z',
                                           'ext'      : 'bytecode',
                                           'name'     : 'test_2.bytecode',
                                           'path'     : 'Exercise/TestsResults/test_2.bytecode'
                                       }, {
                                           'mode'     : 33188,
                                           'size'     : 23,
                                           'mtime'    : '2023-12-08T13:06:31.120Z',
                                           'birthtime': '2023-12-08T13:06:36.338Z',
                                           'ext'      : 'output',
                                           'name'     : 'test_2.output',
                                           'path'     : 'Exercise/TestsResults/test_2.output'
                                       }, {
                                           'mode'     : 33188,
                                           'size'     : 192,
                                           'mtime'    : '2023-12-08T13:06:30.843Z',
                                           'birthtime': '2023-12-08T13:06:36.338Z',
                                           'ext'      : 'source',
                                           'name'     : 'test_2.source',
                                           'path'     : 'Exercise/TestsResults/test_2.source'
                                       }, {
                                           'mode'     : 33188,
                                           'size'     : 1730,
                                           'mtime'    : '2023-12-08T13:06:31.592Z',
                                           'birthtime': '2023-12-08T13:06:36.338Z',
                                           'ext'      : 'bytecode',
                                           'name'     : 'test_3.bytecode',
                                           'path'     : 'Exercise/TestsResults/test_3.bytecode'
                                       }, {
                                           'mode'     : 33188,
                                           'size'     : 32,
                                           'mtime'    : '2023-12-08T13:06:31.695Z',
                                           'birthtime': '2023-12-08T13:06:36.338Z',
                                           'ext'      : 'output',
                                           'name'     : 'test_3.output',
                                           'path'     : 'Exercise/TestsResults/test_3.output'
                                       }, {
                                           'mode'     : 33188,
                                           'size'     : 331,
                                           'mtime'    : '2023-12-08T13:06:31.399Z',
                                           'birthtime': '2023-12-08T13:06:36.338Z',
                                           'ext'      : 'source',
                                           'name'     : 'test_3.source',
                                           'path'     : 'Exercise/TestsResults/test_3.source'
                                       }, {
                                           'mode'     : 33188,
                                           'size'     : 1392,
                                           'mtime'    : '2023-12-08T13:06:32.151Z',
                                           'birthtime': '2023-12-08T13:06:36.339Z',
                                           'ext'      : 'bytecode',
                                           'name'     : 'test_4.bytecode',
                                           'path'     : 'Exercise/TestsResults/test_4.bytecode'
                                       }, {
                                           'mode'     : 33188,
                                           'size'     : 41,
                                           'mtime'    : '2023-12-08T13:06:32.268Z',
                                           'birthtime': '2023-12-08T13:06:36.339Z',
                                           'ext'      : 'output',
                                           'name'     : 'test_4.output',
                                           'path'     : 'Exercise/TestsResults/test_4.output'
                                       }, {
                                           'mode'     : 33188,
                                           'size'     : 280,
                                           'mtime'    : '2023-12-08T13:06:31.953Z',
                                           'birthtime': '2023-12-08T13:06:36.339Z',
                                           'ext'      : 'source',
                                           'name'     : 'test_4.source',
                                           'path'     : 'Exercise/TestsResults/test_4.source'
                                       }, {
                                           'mode'     : 33188,
                                           'size'     : 14810,
                                           'mtime'    : '2023-12-08T13:06:32.728Z',
                                           'birthtime': '2023-12-08T13:06:36.339Z',
                                           'ext'      : 'bytecode',
                                           'name'     : 'test_5.bytecode',
                                           'path'     : 'Exercise/TestsResults/test_5.bytecode'
                                       }, {
                                           'mode'     : 33188,
                                           'size'     : 315,
                                           'mtime'    : '2023-12-08T13:06:32.892Z',
                                           'birthtime': '2023-12-08T13:06:36.339Z',
                                           'ext'      : 'output',
                                           'name'     : 'test_5.output',
                                           'path'     : 'Exercise/TestsResults/test_5.output'
                                       }, {
                                           'mode'     : 33188,
                                           'size'     : 1383,
                                           'mtime'    : '2023-12-08T13:06:32.533Z',
                                           'birthtime': '2023-12-08T13:06:36.339Z',
                                           'ext'      : 'source',
                                           'name'     : 'test_5.source',
                                           'path'     : 'Exercise/TestsResults/test_5.source'
                                       }, {
                                           'mode'     : 33188,
                                           'size'     : 1374,
                                           'mtime'    : '2023-12-08T13:06:33.396Z',
                                           'birthtime': '2023-12-08T13:06:36.339Z',
                                           'ext'      : 'bytecode',
                                           'name'     : 'test_6.bytecode',
                                           'path'     : 'Exercise/TestsResults/test_6.bytecode'
                                       }, {
                                           'mode'     : 33188,
                                           'size'     : 15,
                                           'mtime'    : '2023-12-08T13:06:33.504Z',
                                           'birthtime': '2023-12-08T13:06:36.339Z',
                                           'ext'      : 'output',
                                           'name'     : 'test_6.output',
                                           'path'     : 'Exercise/TestsResults/test_6.output'
                                       }, {
                                           'mode'     : 33188,
                                           'size'     : 410,
                                           'mtime'    : '2023-12-08T13:06:33.180Z',
                                           'birthtime': '2023-12-08T13:06:36.339Z',
                                           'ext'      : 'source',
                                           'name'     : 'test_6.source',
                                           'path'     : 'Exercise/TestsResults/test_6.source'
                                       }, {
                                           'mode'     : 33188,
                                           'size'     : 1471,
                                           'mtime'    : '2023-12-08T13:06:33.958Z',
                                           'birthtime': '2023-12-08T13:06:36.340Z',
                                           'ext'      : 'bytecode',
                                           'name'     : 'test_7.bytecode',
                                           'path'     : 'Exercise/TestsResults/test_7.bytecode'
                                       }, {
                                           'mode'     : 33188,
                                           'size'     : 68,
                                           'mtime'    : '2023-12-08T13:06:34.060Z',
                                           'birthtime': '2023-12-08T13:06:36.340Z',
                                           'ext'      : 'output',
                                           'name'     : 'test_7.output',
                                           'path'     : 'Exercise/TestsResults/test_7.output'
                                       }, {
                                           'mode'     : 33188,
                                           'size'     : 417,
                                           'mtime'    : '2023-12-08T13:06:33.764Z',
                                           'birthtime': '2023-12-08T13:06:36.340Z',
                                           'ext'      : 'source',
                                           'name'     : 'test_7.source',
                                           'path'     : 'Exercise/TestsResults/test_7.source'
                                       }, {
                                           'mode'     : 33188,
                                           'size'     : 1301,
                                           'mtime'    : '2023-12-08T13:06:34.524Z',
                                           'birthtime': '2023-12-08T13:06:36.340Z',
                                           'ext'      : 'bytecode',
                                           'name'     : 'test_8.bytecode',
                                           'path'     : 'Exercise/TestsResults/test_8.bytecode'
                                       }, {
                                           'mode'     : 33188,
                                           'size'     : 72,
                                           'mtime'    : '2023-12-08T13:06:34.654Z',
                                           'birthtime': '2023-12-08T13:06:36.340Z',
                                           'ext'      : 'output',
                                           'name'     : 'test_8.output',
                                           'path'     : 'Exercise/TestsResults/test_8.output'
                                       }, {
                                           'mode'     : 33188,
                                           'size'     : 352,
                                           'mtime'    : '2023-12-08T13:06:34.336Z',
                                           'birthtime': '2023-12-08T13:06:36.340Z',
                                           'ext'      : 'source',
                                           'name'     : 'test_8.source',
                                           'path'     : 'Exercise/TestsResults/test_8.source'
                                       }, {
                                           'mode'     : 33188,
                                           'size'     : 771,
                                           'mtime'    : '2023-12-08T13:06:35.117Z',
                                           'birthtime': '2023-12-08T13:06:36.340Z',
                                           'ext'      : 'bytecode',
                                           'name'     : 'test_9.bytecode',
                                           'path'     : 'Exercise/TestsResults/test_9.bytecode'
                                       }, {
                                           'mode'     : 33188,
                                           'size'     : 31,
                                           'mtime'    : '2023-12-08T13:06:35.257Z',
                                           'birthtime': '2023-12-08T13:06:36.341Z',
                                           'ext'      : 'output',
                                           'name'     : 'test_9.output',
                                           'path'     : 'Exercise/TestsResults/test_9.output'
                                       }, {
                                           'mode'     : 33188,
                                           'size'     : 132,
                                           'mtime'    : '2023-12-08T13:06:34.916Z',
                                           'birthtime': '2023-12-08T13:06:36.340Z',
                                           'ext'      : 'source',
                                           'name'     : 'test_9.source',
                                           'path'     : 'Exercise/TestsResults/test_9.source'
                                       } ],
                                       results   : {
                                           'successfulTests'    : 16,
                                           'failedTests'        : 0,
                                           'successfulTestsList': [ 'Test 1', 'Test 2', 'Test 3', 'Test 4', 'Test 5', 'Test 6', 'Test 7', 'Test 8', 'Test 9', 'Test 10', 'Test 11', 'Semantic error 1', 'Semantic error 2', 'Semantic error 3', 'Semantic error 4', 'Semantic error 5' ],
                                           'failedTestsList'    : [],
                                           'success'            : true,
                                           'containerExitCode'  : 0
                                       },
                                       success   : true
                                   }
                               });
    }
}