import path    from 'node:path';
import cluster from 'node:cluster';
import myEnv = require('dotenv');
import dotenvExpand = require('dotenv-expand');


if ( cluster.isPrimary ) {
    if ( process.env.NODE_ENV && process.env.NODE_ENV === 'production' ) {
        dotenvExpand.expand(myEnv.config());
    } else {
        myEnv.config({ path: path.join(__dirname, '../.env.keys') });
        dotenvExpand.expand(myEnv.config({ DOTENV_KEY: process.env.DOTENV_KEY_DEVELOPMENT }));
    }
}


require('./shared/helpers/TypeScriptExtensions'); // ATTENTION : This line MUST be after the dotenv.config() calls
