require('./InitialImports'); // ATTENTION : These lines MUST be the first of this file

import SharedConfig   from './shared/config/SharedConfig';
import WorkerRole     from './process/WorkerRole';
import ClusterManager from './process/ClusterManager';
import API            from './express/API';
import HttpManager    from './managers/HttpManager';


HttpManager.registerAxiosInterceptor();


if ( SharedConfig.production ) {
    (new ClusterManager([ {
        role         : WorkerRole.API,
        quantity     : ClusterManager.CORES,
        restartOnFail: true,
        loadTask     : () => new API()
    } ])).run();
} else {
    (new API()).run();
}
