import LazyVal from '../shared/helpers/LazyVal';


class DojoModelsHelper {
    /**
     * Get a full serializable object from a given object that contains LazyVal instances
     *
     * @param obj
     * @param depth The depth of the search for LazyVal instances
     */
    async getFullSerializableObject<T extends NonNullable<unknown>>(obj: T, depth: number = 0): Promise<unknown> {
        const result: { [key: string]: unknown } = {};

        for ( const key in obj ) {
            let value: unknown = obj[key];
            if ( value instanceof LazyVal ) {
                value = await (obj[key] as LazyVal<unknown>).value;
            }

            if ( typeof value === 'object' && obj[key] !== null && depth > 0 ) {
                result[key] = await this.getFullSerializableObject(value as NonNullable<unknown>, depth - 1);
            } else {
                result[key] = value;
            }
        }

        return result;
    }
}


export default new DojoModelsHelper();