import { Prisma }   from '@prisma/client';
import { Exercise } from '../types/DatabaseTypes';
import db           from '../helpers/DatabaseHelper';


class ExerciseManager {
    async get(idOrUrl: string, include: Prisma.ExerciseInclude | undefined = undefined): Promise<Exercise | undefined> {
        const id = idOrUrl.replace('.git', '').split('_').pop()!;

        return await db.exercise.findUnique({
                                                where  : {
                                                    id: id
                                                },
                                                include: include
                                            }) as unknown as Exercise ?? undefined;
    }

    async getFromAssignment(assignmentName: string, include: Prisma.ExerciseInclude | undefined = undefined): Promise<Array<Exercise> | undefined> {
        return await db.exercise.findMany({
                                              where  : {
                                                  assignmentName: assignmentName
                                              },
                                              include: include
                                          }) as Array<Exercise> ?? undefined;
    }
}


export default new ExerciseManager();
