// Read from the .env file
// ATTENTION : These lines MUST be the first of this file (except for the path import)
import path = require('node:path');
import myEnv = require('dotenv');
import dotenvExpand = require('dotenv-expand');


dotenvExpand.expand(myEnv.config({
                                     path      : path.join(__dirname, '../.env'),
                                     DOTENV_KEY: 'dotenv://:key_f1778b6998874f6fd78c716ccef982c5595fa300f174b129eafc88ba7044d69b@dotenv.local/vault/.env.vault?environment=development'
                                 }));

require('./shared/helpers/TypeScriptExtensions'); // ATTENTION : This line MUST be the second of this file


import ClientsSharedAssignmentHelper from './sharedByClients/helpers/Dojo/ClientsSharedAssignmentHelper';
import AssignmentValidator           from './sharedByClients/helpers/Dojo/AssignmentValidator';
import Styles                        from './types/Style';
import HttpManager                   from './managers/HttpManager';
import Config                        from './config/Config';
import Icon                          from './sharedByClients/types/Icon';


(async () => {
    HttpManager.registerAxiosInterceptor();

    console.log(Styles.APP_NAME(`${ Config.appName } (version {{VERSION}})`));

    const assignmentValidator = new AssignmentValidator(Config.folders.project);

    try {
        await new Promise<void>((resolve, reject) => {
            assignmentValidator.events.on('step', (name: string, message: string) => {
                console.log(Styles.CAT_INFO(`${ Icon.CAT_INFO } ${ message }`));
            });

            assignmentValidator.events.on('subStep', (name: string, message: string) => {
                console.log(Styles.INFO(`\t${ Icon.INFO } ${ message }`));
            });

            assignmentValidator.events.on('endSubStep', (stepName: string, message: string, error: boolean) => {
                if ( error ) {
                    console.error(Styles.ERROR(`\t${ Icon.ERROR } ${ message }`));
                }
            });

            assignmentValidator.events.on('finished', (success: boolean) => {
                success ? resolve() : reject();
            });

            assignmentValidator.run();
        });
    } catch ( error ) { /* empty */ }

    ClientsSharedAssignmentHelper.displayExecutionResults(assignmentValidator, `The assignment is ready to be published.`, Styles);

    process.exit(assignmentValidator.exitCode);
})();