// ATTENTION : This line MUST be the first of this file
import './init.js';
import ClientsSharedAssignmentHelper from './sharedByClients/helpers/Dojo/ClientsSharedAssignmentHelper.js';
import AssignmentValidator           from './sharedByClients/helpers/Dojo/AssignmentValidator.js';
import Styles                        from './types/Style.js';
import HttpManager                   from './managers/HttpManager.js';
import Config                        from './config/Config.js';
import Icon                          from './shared/types/Icon.js';


void (async () => {
    HttpManager.registerAxiosInterceptor();

    console.log(Styles.APP_NAME(`${ Config.appName } (version {{VERSION}})`));

    const assignmentValidator = new AssignmentValidator(Config.folders.project);

    try {
        await new Promise<void>((resolve, reject) => {
            assignmentValidator.events.on('step', (_name: string, message: string) => {
                console.log(Styles.CAT_INFO(`${ Icon.CAT_INFO } ${ message }`));
            });

            assignmentValidator.events.on('subStep', (_name: string, message: string) => {
                console.log(Styles.INFO(`\t${ Icon.INFO } ${ message }`));
            });

            assignmentValidator.events.on('endSubStep', (_stepName: string, message: string, error: boolean) => {
                if ( error ) {
                    console.error(Styles.ERROR(`\t${ Icon.ERROR } ${ message }`));
                }
            });

            assignmentValidator.events.on('finished', (success: boolean) => {
                success ? resolve() : reject();
            });

            assignmentValidator.run();
        });
    } catch ( error ) { /* empty */ }

    ClientsSharedAssignmentHelper.displayExecutionResults(assignmentValidator, `The assignment is ready to be published.`, Styles);

    process.exit(assignmentValidator.exitCode);
})();