import fs   from 'fs-extra';
import path from 'path';


class Config {
    public readonly appName: string;

    public readonly folders: {
        project: string; resultsVolume: string; resultsDojo: string; resultsExercise: string;
    };

    public readonly dockerhub: {
        repositories: {
            assignmentChecker: string
        }
    };

    constructor() {
        this.appName = process.env.APP_NAME || '';

        this.folders = {
            project        : process.env.PROJECT_FOLDER?.convertWithEnvVars() ?? './',
            resultsVolume  : process.env.EXERCISE_RESULTS_VOLUME?.convertWithEnvVars() ?? '',
            resultsDojo    : path.join(process.env.EXERCISE_RESULTS_VOLUME?.convertWithEnvVars() ?? '', 'Dojo/'),
            resultsExercise: path.join(process.env.EXERCISE_RESULTS_VOLUME?.convertWithEnvVars() ?? '', 'Exercise/')
        };
        this.resetResultsVolume();

        this.dockerhub = {
            repositories: {
                assignmentChecker: process.env.DOCKERHUB_ASSIGNMENT_CHECKER_REPOSITORY || ''
            }
        };
    }

    private resetResultsVolume(): void {
        fs.emptyDirSync(this.folders.resultsVolume);
        fs.emptyDirSync(this.folders.resultsDojo);
        fs.emptyDirSync(this.folders.resultsExercise);
    }
}


export default new Config();
