import axios               from 'axios';
import DojoBackendResponse from '../shared/types/Dojo/DojoBackendResponse.js';
import ExerciseAssignment  from '../sharedByClients/models/ExerciseAssignment.js';
import Config              from '../config/Config.js';
import ExerciseResultsFile from '../shared/types/Dojo/ExerciseResultsFile.js';
import ApiRoute            from '../sharedByClients/types/Dojo/ApiRoute.js';
import { IFileDirStat }    from '../shared/helpers/recursiveFilesStats/RecursiveFilesStats.js';
import DojoBackendHelper   from '../sharedByClients/helpers/Dojo/DojoBackendHelper.js';
import Exercise            from '../sharedByClients/models/Exercise';


class DojoBackendManager {
    public async getExercise(): Promise<Exercise | undefined> {
        try {
            return (await axios.get<DojoBackendResponse<Exercise>>(DojoBackendHelper.getApiUrl(ApiRoute.EXERCISE_GET_DELETE).replace('{{id}}', Config.exercise.id))).data.data;
        } catch ( error ) {
            return undefined;
        }
    }

    public async getExerciseAssignment(): Promise<ExerciseAssignment | undefined> {
        try {
            return (await axios.get<DojoBackendResponse<ExerciseAssignment>>(DojoBackendHelper.getApiUrl(ApiRoute.EXERCISE_ASSIGNMENT, { exerciseIdOrUrl: Config.exercise.id }))).data.data;
        } catch ( error ) {
            return undefined;
        }
    }

    public async sendResults(exitCode: number, commit: Record<string, string>, results: ExerciseResultsFile, sonarGatePass: boolean | undefined, files: Array<IFileDirStat>, archiveBase64: string): Promise<void> {
        await axios.post(this.getApiUrl(ApiRoute.EXERCISE_RESULTS).replace('{{id}}', Config.exercise.id), {
            exitCode     : exitCode,
            commit       : JSON.stringify(commit),
            results      : JSON.stringify(results),
            sonarGatePass: sonarGatePass?.toString() ?? "",
            files        : JSON.stringify(files),
            archiveBase64: archiveBase64
        });
    }
}


export default new DojoBackendManager();
