import ClientsSharedConfig from '../sharedByClients/config/ClientsSharedConfig';
import axios               from 'axios';
import DojoBackendResponse from '../shared/types/Dojo/DojoBackendResponse';
import ExerciseAssignment  from '../sharedByClients/models/ExerciseAssignment';
import Config              from '../config/Config';
import ExerciseResultsFile from '../shared/types/Dojo/ExerciseResultsFile';
import ApiRoute            from '../sharedByClients/types/Dojo/ApiRoute';
import { IFileDirStat }    from '../shared/helpers/recursiveFilesStats/RecursiveFilesStats';


class DojoBackendManager {
    public getApiUrl(route: ApiRoute): string {
        return `${ ClientsSharedConfig.apiURL }${ route }`;
    }

    public async getExerciseAssignment(): Promise<ExerciseAssignment | undefined> {
        try {
            return (await axios.get<DojoBackendResponse<ExerciseAssignment>>(this.getApiUrl(ApiRoute.EXERCISE_ASSIGNMENT).replace('{{id}}', Config.exercise.id))).data.data;
        } catch ( error ) {
            return undefined;
        }
    }

    public async sendResults(exitCode: number, commit: Record<string, string>, results: ExerciseResultsFile, files: Array<IFileDirStat>, archiveBase64: string): Promise<void> {
        await axios.post(this.getApiUrl(ApiRoute.EXERCISE_RESULTS).replace('{{id}}', Config.exercise.id), {
            exitCode     : exitCode,
            commit       : JSON.stringify(commit),
            results      : JSON.stringify(results),
            files        : JSON.stringify(files),
            archiveBase64: archiveBase64
        });
    }
}


export default new DojoBackendManager();
