import ExerciceResultsFile from '../../../shared/types/Dojo/ExerciceResultsFile';
import chalk               from 'chalk';
import boxen               from 'boxen';
import Icon                from '../../types/Icon';


class ClientsSharedExerciceHelper {
    displayExecutionResults(exerciceResults: ExerciceResultsFile, containerExitCode: number, Style: { INFO: chalk.Chalk, SUCCESS: chalk.Chalk, FAILURE: chalk.Chalk }, additionalText: string = '') {
        const finalLogGlobalResult = `${ Style.INFO('Global result') } : ${ exerciceResults.success ? Style.SUCCESS(`${ Icon.SUCCESS } Success`) : Style.FAILURE(`${ Icon.FAILURE } Failure`) }`;

        const finalLogExecutionExitCode = `${ Style.INFO('Execution exit code') } : ${ (containerExitCode == 0 ? Style.SUCCESS : Style.FAILURE)(containerExitCode) }`;

        const finalLogResultNumbers = exerciceResults.successfulTests || exerciceResults.failedTests ? `\n\n${ Style.SUCCESS('Tests passed') } : ${ exerciceResults.successfulTests ?? '--' }\n${ Style.FAILURE('Tests failed') } : ${ exerciceResults.failedTests ?? '--' }` : '';

        const finalLogSuccessResultDetails = (exerciceResults.successfulTestsList ?? []).map(testName => `- ${ Icon.SUCCESS } ${ testName }`).join('\n');
        const finalLogFailedResultDetails = (exerciceResults.failedTestsList ?? []).map(testName => `- ${ Icon.FAILURE } ${ testName }`).join('\n');
        const finalLogResultDetails = exerciceResults.successfulTestsList || exerciceResults.failedTestsList ? `\n\n${ Style.INFO('Tests') } :${ finalLogSuccessResultDetails != '' ? '\n' + finalLogSuccessResultDetails : '' }${ finalLogFailedResultDetails != '' ? '\n' + finalLogFailedResultDetails : '' }` : '';

        console.log(boxen(`${ finalLogGlobalResult }\n\n${ finalLogExecutionExitCode }${ finalLogResultNumbers }${ finalLogResultDetails }${ additionalText }`, {
            title         : 'Results',
            titleAlignment: 'center',
            borderColor   : 'yellow',
            borderStyle   : 'bold',
            margin        : 1,
            padding       : 1,
            textAlignment : 'left'
        }));
    }
}


export default new ClientsSharedExerciceHelper();