import UserRole    from './UserRole';
import Exercise    from './Exercise';
import Assignment  from './Assignment';
import * as Gitlab from '@gitbeaker/rest';


interface User {
    id: number;
    name: string;
    mail: string;
    role: UserRole;
    gitlabUsername: string;
    gitlabLastInfo: Gitlab.ExpandedUserSchema;
    isTeachingStaff: boolean;
    isAdmin: boolean;
    deleted: boolean;

    assignments?: Array<Assignment>;
    exercises?: Array<Exercise>;
}


export default User;
