import UserRole      from './UserRole';
import Exercise      from './Exercise';
import Assignment    from './Assignment';
import GitlabProfile from '../../shared/types/Gitlab/GitlabProfile';


interface User {
    id: number;
    name: string;
    mail: string;
    role: UserRole;
    gitlabUsername: string;
    gitlabLastInfo: GitlabProfile;
    isTeachingStaff: boolean;
    isAdmin: boolean;
    deleted: boolean;

    assignments?: Array<Assignment>;
    exercises?: Array<Exercise>;
}


export default User;
