import { ChalkInstance }   from 'chalk';
import boxen               from 'boxen';
import Icon                from '../../../shared/types/Icon.js';
import AssignmentValidator from './AssignmentValidator.js';


class ClientsSharedAssignmentHelper {
    displayExecutionResults(validator: AssignmentValidator, successMessage: string, Style: { INFO: ChalkInstance, SUCCESS: ChalkInstance, FAILURE: ChalkInstance }) {
        const globalResult = validator.success ? Style.SUCCESS(`${ Icon.SUCCESS } Success`) : Style.FAILURE(`${ Icon.FAILURE } Failure`);
        const finalLogGlobalResult = `${ Style.INFO('Global result') } : ${ globalResult }`;

        const finalLogSuccessMessage = validator.success ? `${ successMessage }` : '';
        const finalLogErrorMessage = !validator.success ? `${ Style.INFO('Error message') } :\n${ Style.FAILURE(validator.fatalErrorMessage) }` : '';

        console.log(boxen(`${ finalLogGlobalResult }\n\n${ finalLogSuccessMessage }${ finalLogErrorMessage }`, {
            title         : 'Results',
            titleAlignment: 'center',
            borderColor   : validator.success ? 'green' : 'red',
            borderStyle   : 'bold',
            margin        : 1,
            padding       : 1,
            textAlignment : 'left'
        }));
    }
}


export default new ClientsSharedAssignmentHelper();