import ApiRoute            from '../../types/Dojo/ApiRoute.js';
import ClientsSharedConfig from '../../config/ClientsSharedConfig.js';


class DojoBackendHelper {
    public getApiUrl(route: ApiRoute, options?: Partial<{ assignmentNameOrUrl: string, exerciseIdOrUrl: string, gitlabProjectId: string }>): string {
        const url = `${ ClientsSharedConfig.apiURL }${ route }`;

        if ( options ) {
            if ( options.assignmentNameOrUrl ) {
                return url.replace('{{assignmentNameOrUrl}}', encodeURIComponent(options.assignmentNameOrUrl));
            }

            if ( options.exerciseIdOrUrl ) {
                return url.replace('{{exerciseIdOrUrl}}', encodeURIComponent(options.exerciseIdOrUrl));
            }

            if ( options.gitlabProjectId ) {
                return url.replace('{{gitlabProjectId}}', encodeURIComponent(options.gitlabProjectId));
            }
        }

        return url;
    }
}


export default new DojoBackendHelper();