import ApiRoute            from '../../types/Dojo/ApiRoute.js';
import ClientsSharedConfig from '../../config/ClientsSharedConfig';


class DojoBackendHelper {
    public getApiUrl(route: ApiRoute, options?: Partial<{ userId: number, assignmentNameOrUrl: string, exerciseIdOrUrl: string, gitlabProjectId: string, tagName: string }>): string {
        let url = `${ ClientsSharedConfig.apiURL }${ route }`;

        if ( options ) {
            if ( options.userId ) {
                url = url.replace('{{userId}}', encodeURIComponent(options.userId.toString()));
            }
            
            if ( options.assignmentNameOrUrl ) {
                url = url.replace('{{assignmentNameOrUrl}}', encodeURIComponent(options.assignmentNameOrUrl));
            }

            if ( options.exerciseIdOrUrl ) {
                url = url.replace('{{exerciseIdOrUrl}}', encodeURIComponent(options.exerciseIdOrUrl));
            }

            if ( options.gitlabProjectId ) {
                url = url.replace('{{gitlabProjectId}}', encodeURIComponent(options.gitlabProjectId));
            }

            if ( options.tagName ) {
                url = url.replace('{{tagName}}', encodeURIComponent(options.tagName));
            }
        }

        return url;
    }
}


export default new DojoBackendHelper();