import { spawnSync } from 'node:child_process';
import { Language }  from '../../models/Assignment';
import SharedConfig  from '../../../shared/config/SharedConfig';


const IMAGE_NAME = 'dojo-sonar-scanner';
const OUT_DIR = 'bw-output';


class SonarAnalyzer {
    buildDocker = () => {
        const buildProcess = spawnSync('docker', [ 'build', '--tag', IMAGE_NAME, '/sonar' ]);
        if ( buildProcess.status !== 0 ) {
            console.log(buildProcess.stdout.toString());
            console.log(buildProcess.stderr.toString());
            return false;
        }
        return true;
    };

    mustRunBuild = (language: Language, buildLine: string | undefined) => {
        return [ Language.c, Language.cpp, Language.objc ].includes(language) && buildLine != undefined;
    };

    runBuildStep = (buildLine: string) => {
        const process = spawnSync(`docker run -v ./:/usr/src ${ IMAGE_NAME } /usr/local/bin/build-wrapper-linux-x86-64 --out-dir ${ OUT_DIR } ` + buildLine, [], { shell: true });
        if ( process.status !== 0 ) {
            console.log(process.stdout.toString());
            console.log(process.stderr.toString());
            return false;
        }
        return true;
    };

    runAnalysis = (sonarKey: string, language: Language, buildLine: string | undefined): boolean => {
        let addParam: string[] = [];
        if ( this.mustRunBuild(language, buildLine) ) {
            addParam = [ `-Dsonar.cfamily.build-wrapper-output=/usr/src/${ OUT_DIR }` ];
        }

        const process = spawnSync('docker', [ 'run', '-v', './:/usr/src', IMAGE_NAME, 'sonar-scanner', '-Dsonar.qualitygate.wait=true', '-Dsonar.projectKey=' + sonarKey, '-Dsonar.sources=.', '-Dsonar.host.url=' + SharedConfig.sonar.url, '-Dsonar.login=' + SharedConfig.sonar.token, ...addParam ]);

        return process.status === 0;
    };
}


export default new SonarAnalyzer();