import User        from './User.js';
import Exercise    from './Exercise.js';
import * as Gitlab from '@gitbeaker/rest';
import SonarProjectCreation from '../../shared/types/Sonar/SonarProjectCreation';


interface Assignment {
    name: string;
    gitlabId: number;
    gitlabLink: string;
    gitlabCreationInfo: Gitlab.ProjectSchema;
    gitlabLastInfo: Gitlab.ProjectSchema;
    gitlabLastInfoDate: string;
    published: boolean;
    useSonar: boolean;
    allowSonarFailure: boolean;
    sonarKey: string;
    sonarCreationInfo: SonarProjectCreation;
    language: Language;

    staff: Array<User>;
    exercises: Array<Exercise>;

    corrections: Array<Exercise>;
}


export enum Language {
    abap = "abap",
    ada = "ada",
    asm = "asm",
    bash = "bash",
    bqn = "bqn",
    c = "c",
    caml = "caml",
    cloudformation = "cloudformation",
    cpp = "cpp",
    csharp = "csharp",
    css = "css",
    cuda = "cuda",
    dart = "dart",
    delphi = "delphi",
    docker = "docker",
    erlang = "erlang",
    f = "f",
    fsharp = "fsharp",
    flex = "flex",
    fortran = "fortran",
    futhark = "futhark",
    go = "go",
    groovy = "groovy",
    haskell = "haskell",
    hepial = "hepial",
    json = "json",
    jsp = "jsp",
    java = "java",
    js = "js",
    julia = "julia",
    kotlin = "kotlin",
    kubernetes = "kubernetes",
    latex = "latex",
    lisp = "lisp",
    lua = "lua",
    matlab = "matlab",
    objc = "objc",
    ocaml = "ocaml",
    pascal = "pascal",
    pearl = "pearl",
    perl = "perl",
    php = "php",
    postscript = "postscript",
    powershell = "powershell",
    prolog = "prolog",
    promela = "promela",
    python = "python",
    r = "r",
    ruby = "ruby",
    rust = "rust",
    scala = "scala",
    sql = "sql",
    smalltalk = "smalltalk",
    swift = "swift",
    terraform = "terraform",
    text = "text",
    ts = "ts",
    tsql = "tsql",
    typst = "typst",
    vba = "vba",
    vbnet = "vbnet",
    web = "web",
    xml = "xml",
    yaml = "yaml",

    other = "other"
}


export default Assignment;
