import User        from './User.js';
import Assignment  from './Assignment.js';
import * as Gitlab from '@gitbeaker/rest';
import SonarProjectCreation from '../../shared/types/Sonar/SonarProjectCreation';


interface Exercise {
    id: string;
    assignmentName: string;
    name: string;
    gitlabId: number;
    gitlabLink: string;
    gitlabCreationInfo: Gitlab.ProjectSchema;
    gitlabLastInfo: Gitlab.ProjectSchema;
    gitlabLastInfoDate: string;

    sonarKey: string;
    sonarCreationInfo: SonarProjectCreation;

    members: Array<User> | undefined;
    assignment: Assignment | undefined;

    isCorrection: boolean;
    correctionCommit: Gitlab.CommitSchema | undefined;
    correctionDescription: string | undefined;
}


export default Exercise;