import Ajv, { ErrorObject, JTDSchemaType } from 'ajv/dist/jtd';
import fs                                  from 'fs';
import ExerciceResultsFile                 from '../types/Dojo/ExerciceResultsFile';
import JSON5                               from 'json5';


class ExerciceHelper {
    validateResultFile(resultsFilePath: string): {
        results: ExerciceResultsFile | undefined, isValid: boolean, errors: Array<ErrorObject<string, Record<string, any>, unknown> | string> | null | undefined
    } {
        const ajv = new Ajv();

        const schema: JTDSchemaType<ExerciceResultsFile> = {
            properties          : {
                success: { type: 'boolean' }
            },
            optionalProperties  : {
                successfulTests: { type: 'uint32' },
                failedTests    : { type: 'uint32' },

                successfulTestsList: {
                    elements: {
                        type: 'string'
                    }
                },
                failedTestsList    : {
                    elements: {
                        type: 'string'
                    }
                }
            },
            additionalProperties: false
        };

        const validator = ajv.compile(schema);

        try {
            const results = JSON5.parse(fs.readFileSync(resultsFilePath, 'utf8'));
            const isValid = validator(results);

            return {
                results: isValid ? results as ExerciceResultsFile : results as any,
                isValid: isValid,
                errors : validator.errors
            };
        } catch ( error ) {
            return {
                results: undefined,
                isValid: false,
                errors : [ `JSON5 invalid : ${ JSON.stringify(error) }` ]
            };
        }
    }
}


export default new ExerciceHelper();