class LazyVal<T> {
    private val: T | undefined = undefined;
    private readonly valLoader: () => Promise<T> | T;

    constructor(valLoader: () => Promise<T> | T) {
        this.valLoader = valLoader;
    }

    get value(): Promise<T> {
        return new Promise<T>(resolve => {
            if ( this.val === undefined ) {
                Promise.resolve(this.valLoader()).then((value: T) => {
                    this.val = value;
                    resolve(value);
                });
            } else {
                resolve(this.val);
            }
        });
    }

    reset() {
        this.val = undefined;
    }

    get isValueLoaded(): boolean {
        return this.val !== undefined;
    }
}


export default LazyVal;
