class LazyVal<T> {
    private val: T | undefined = undefined;

    constructor(private valLoader: () => Promise<T> | T) {}

    get value(): Promise<T> {
        return new Promise<T>(async (resolve) => {
            if ( this.val === undefined ) {
                this.val = await this.valLoader();
            }

            resolve(this.val);
        });
    }

    reset() {
        this.val = undefined;
    }

    get isValueLoaded(): boolean {
        return this.val !== undefined;
    }
}


export default LazyVal;
