class Toolbox {
    private static _instance: Toolbox;

    private constructor() { }

    public static get instance(): Toolbox {
        if ( !Toolbox._instance ) {
            Toolbox._instance = new Toolbox();
        }

        return Toolbox._instance;
    }

    public urlToPath(url: string): string {
        return url.replace(/^([a-z]{3,5}:\/{2})?[a-z.@]+(:[0-9]{1,5})?.(.*)/, '$3').replace('.git', '');
    }
}


export default Toolbox.instance;
