import AssignmentFile       from '../../types/Dojo/AssignmentFile';
import GitlabPipelineStatus from '../../types/Gitlab/GitlabPipelineStatus';
import DojoStatusCode       from '../../types/Dojo/DojoStatusCode';
import GitlabPipeline       from '../../types/Gitlab/GitlabPipeline';
import SharedGitlabManager  from '../../managers/SharedGitlabManager';
import Json5FileValidator   from '../Json5FileValidator';


class SharedAssignmentHelper {
    validateDescriptionFile(filePathOrStr: string, isFile: boolean = true, version: number = 1): { content: AssignmentFile | undefined, isValid: boolean, error: string | null } {
        if ( version === 1 ) {
            return Json5FileValidator.validateFile(AssignmentFile, filePathOrStr, isFile);
        } else {
            return {
                content: undefined,
                isValid: false,
                error  : `Version ${ version } not supported`
            };
        }
    }

    async isPublishable(repositoryId: number): Promise<{ isPublishable: boolean, lastPipeline: GitlabPipeline | null, status?: { code: DojoStatusCode, message: string } }> {
        const pipelines = await SharedGitlabManager.getRepositoryPipelines(repositoryId, 'main');
        if ( pipelines.length > 0 ) {
            const lastPipeline = pipelines[0];
            if ( lastPipeline.status !== GitlabPipelineStatus.SUCCESS ) {
                return {
                    isPublishable: false,
                    lastPipeline : lastPipeline,
                    status       : {
                        code   : DojoStatusCode.ASSIGNMENT_PUBLISH_PIPELINE_FAILED,
                        message: `Last pipeline status is not "${ GitlabPipelineStatus.SUCCESS }" but "${ lastPipeline.status }".`
                    }
                };
            } else {
                return {
                    isPublishable: true,
                    lastPipeline : lastPipeline
                };
            }
        } else {
            return {
                isPublishable: false,
                lastPipeline : null,
                status       : {
                    code   : DojoStatusCode.ASSIGNMENT_PUBLISH_NO_PIPELINE,
                    message: 'No pipeline found for this assignment.'
                }
            };
        }
    }
}


export default new SharedAssignmentHelper();