class SharedConfig {
    public readonly production: boolean;

    public readonly logsFolder: string;

    public gitlab: {
        apiURL: string
    };


    constructor() {
        this.production = process.env.NODE_ENV === 'production';

        this.logsFolder = process.env.LOGS_FOLDER || '';

        this.gitlab = {
            apiURL: process.env.GITLAB_API_URL || ''
        };
    }
}


export default new SharedConfig();
