import Ajv, { ErrorObject, JTDSchemaType } from 'ajv/dist/jtd';
import fs                                  from 'fs';
import ExerciseResultsFile                 from '../../types/Dojo/ExerciseResultsFile';
import JSON5                               from 'json5';


class SharedExerciseHelper {
    validateResultFile(resultsFilePathOrStr: string, isFile: boolean = true): { results: ExerciseResultsFile | undefined, isValid: boolean, errors: Array<ErrorObject<string, Record<string, any>, unknown> | string> | null | undefined } {
        const ajv = new Ajv();

        const schema: JTDSchemaType<ExerciseResultsFile> = {
            properties          : {},
            optionalProperties  : {
                success: { type: 'boolean' },

                containerExitCode: { type: 'uint32' },

                successfulTests: { type: 'uint32' },
                failedTests    : { type: 'uint32' },

                successfulTestsList: {
                    elements: {
                        type: 'string'
                    }
                },
                failedTestsList    : {
                    elements: {
                        type: 'string'
                    }
                }
            },
            additionalProperties: false
        };

        const validator = ajv.compile(schema);

        try {
            const results = JSON5.parse(isFile ? fs.readFileSync(resultsFilePathOrStr, 'utf8') : resultsFilePathOrStr);
            const isValid = validator(results);

            if ( isValid ) {
                if ( results.successfulTests === undefined && results.successfulTestsList !== undefined ) {
                    results.successfulTests = results.successfulTestsList.length;
                }

                if ( results.failedTests === undefined && results.failedTestsList !== undefined ) {
                    results.failedTests = results.failedTestsList.length;
                }
            }

            return {
                results: isValid ? results : results as any,
                isValid: isValid,
                errors : validator.errors
            };
        } catch ( error ) {
            return {
                results: undefined,
                isValid: false,
                errors : [ `JSON5 invalid : ${ JSON.stringify(error) }` ]
            };
        }
    }
}


export default new SharedExerciseHelper();